<?php
class Plugg_Message_Plugin extends Plugg_Plugin implements Plugg_User_Widget, Plugg_User_Tab, Plugg_User_Menu
{   
    const MESSAGE_TYPE_INCOMING = 0;
    const MESSAGE_TYPE_OUTGOING = 1;
    
    public function onPluggAdminRoutes($routes)
    {
        parent::_onPluggAdminRoutes($routes);
    }
    
    public function onUserMainIdentityRoutes($routes)
    {
        $routes['message'] = array(
            'file' => $this->_path . '/User/Main/Identity.php',
            'controller' => 'Plugg_Message_User_Main_Identity',
            'context'=> array('plugin' => $this),
        );
    }
    
    public function onPluggCron($lastrun)
    {
        // Allow run this cron 1 time per day at most
        if (!empty($lastrun) && time() - $lastrun < 86400) return;
        
        if (!$delete_days = intval($this->getParam('deleteOlderThanDays'))) return;
        
        $model = $this->getModel();
        
        // Remove messages if no star and older than X days
        $criteria = $model->createCriteria('Message')
            ->star_is(0)
            ->created_isSmallerThan($delete_days * 86400);
        
        $model->getGateway('Message')->deleteByCriteria($criteria);
    }
    
    public function onUserIdentityDeleteSuccess($identity)
    {
        $id = $identity->getId();
        $model = $this->getModel();
        
        // Remove stat data if any
        $model->getGateway('Message')->deleteByCriteria($model->createCriteria('Message')->userid_is($id));
    }
    
    
    /* Start implementation of Plugg_User_Widget */
   
    public function userWidgetGetNames()
    {
        return array(
            'default' => array($this->_('Send message'), Plugg_User_Plugin::WIDGET_TYPE_MINI)
        );
    }
    
    public function userWidgetGetNicename($widgetName)
    {
        return $this->_('"Send message" button');
    }
    
    public function userWidgetGetContent($widgetName, Sabai_User $viewer, Sabai_Template_PHP $template, Sabai_User_Identity $identity, $isMini)
    {
        if ($viewer->isAuthenticated() && $viewer->getId() != $identity->getId()) {
            return sprintf('<a style="background-image:url(%s)" class="user-widget-button" href="%s">%s</a>', $this->url->getImageUrl($this->getLibrary(), 'message.gif'), $this->url->create(array('base' => '/user', 'path' => '/' . $viewer->getId() . '/message/new', 'params' => array('to' => $identity->getUsername()))), $this->_('Send message'));
        }
    }
    /* End implementation of Plugg_User_Widget */
    
    
    /* Start implementation of Plugg_User_Tab */
    
    public function userTabGetNames()
    {
        return array(
            'default' => array($this->getNiceName(), Plugg_User_Plugin::TAB_TYPE_PRIVATE_ACTIVE)
        );
    }
    
    public function userTabGetNicename($tabName)
    {
        switch ($tabName) {
            case 'default':
                return $this->getNiceName();
        }
    }

    public function userTabGetContent($tabName, Sabai_Request_Web $request, Sabai_User $user, Sabai_Template_PHP $template, $tabId, Sabai_User_Identity $identity)
    {
        switch ($tabName) {
            case 'default':
                return $this->_renderDefaultUserTab($request, $user, $template, $tabId, $identity);
        }
    }

    private function _renderDefaultUserTab($request, $user, $template, $tabId, $identity)
    {
        $id = $identity->getId();
        $messages_type = $request->getAsInt('tab_messages_type', self::MESSAGE_TYPE_INCOMING, array(self::MESSAGE_TYPE_INCOMING, self::MESSAGE_TYPE_OUTGOING));
        $model = $this->getModel();
        $criteria = $model->createCriteria('Message')->type_is($messages_type);
        switch ($messages_select = $request->getAsStr('tab_messages_select')) {
            case 'read':
                $criteria->deleted_is(0)->read_is(1);
                break;
            case 'unread':
                $criteria->deleted_is(0)->read_is(0);
                break;
            case 'starred':
                $criteria->deleted_is(0)->star_is(1);
                break;
            case 'unstarred':
                $criteria->deleted_is(0)->star_is(0);
                break;
            default:
                $criteria->deleted_is(0);
                $messages_select = 'all';
        }
        
        $messages_sortby_allowed = array(
            'created,DESC' => $this->_('Newest first'),
            'created,ASC' => $this->_('Oldest first'),
        );
        $messages_sortby = $request->getAsStr('tab_messages_sortby', 'created,DESC', array_keys($messages_sortby_allowed));
        $sortby = explode(',', $messages_sortby);
        $pages = $model->Message->paginateByUserAndCriteria($id, $criteria, 20, 'message_' . $sortby[0], $sortby[1]);
        $page = $pages->getValidPage($request->getAsInt('tab_messages_page', 1));
        $vars = array(
            'is_owner' => $is_owner = $user->getId() == $id,
            'identity' => $identity,
            'tab_id' => $tabId,
            'messages' => $page->getElements(),
            'messages_pages' => $pages,
            'messages_page' => $page,
            'messages_count_last' => $messages_count_last = $page->getOffset() + $page->getLimit(),
            'messages_count_first' => $messages_count_last > 0 ? $page->getOffset() + 1 : 0,
            'messages_sortby' => $messages_sortby,
            'messages_sortby_allowed' => $messages_sortby_allowed,
            'messages_select' => $messages_select,
            'messages_type' => $messages_type
        );
        return $template->render('plugg_message_user_tab_default.tpl', $vars);
    }
    /* End implementation of Plugg_User_Tab */
    
    
    /* Start implementation of Plugg_User_Menu */
    
    public function userMenuGetNames()
    {
        return array('inbox' => array('', Plugg_User_Plugin::MENU_TYPE_NONEDITABLE));
    }
    
    public function userMenuGetNicename($menuName)
    {
        return $this->_('New messages');
    }
    
    public function userMenuGetLinkText($menuName, $menuTitle, Sabai_User $user)
    {
        $model = $this->getModel();
        $criteria = $model->createCriteria('Message')
            ->type_is(self::MESSAGE_TYPE_INCOMING)
            ->read_is(0);
        if ($count = $model->Message->countByUserAndCriteria($user->getId(), $criteria)) {
            return sprintf($this->_('Inbox (<strong>%d</strong>)'), $count);
        } else {
            return $this->_('Inbox');
        }
    }
    
    public function userMenuGetLinkUrl($menuName, Sabai_User $user)
    {
        return $this->url->create(array('base' => '/user/' . $user->getId(), 'path' => '/message'));
    }
    /* End implementation of Plugg_User_Menu */
}