/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.jnl.XMLFormat;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;

public class LaunchDescFactory {
    private static final boolean DEBUG = false;
    private static final int BUFFER_SIZE = 8192;

    public static LaunchDesc buildDescriptor(byte[] byArray, URL uRL, URL uRL2) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        return XMLFormat.parse(byArray, uRL, uRL2, LaunchSelection.createDefaultMatchJRE());
    }

    public static LaunchDesc buildDescriptor(File file, URL uRL, URL uRL2) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        return LaunchDescFactory.buildDescriptor(LaunchDescFactory.readBytes(new FileInputStream(file), file.length()), uRL, uRL2);
    }

    public static LaunchDesc buildDescriptor(URL uRL, URL uRL2) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        File file = DownloadEngine.getCachedFile((URL)uRL, null, (boolean)true, (boolean)false, null);
        URL uRL3 = URLUtil.asPathURL((URL)URLUtil.getBase((URL)uRL));
        if (file != null) {
            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file, uRL3, uRL2);
            if (launchDesc != null && launchDesc.getLaunchType() == 5) {
                DownloadEngine.removeCachedResource((URL)uRL, null, null);
            }
            return launchDesc;
        }
        HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
        HttpResponse httpResponse = httpRequest.doGetRequest(uRL);
        FilterInputStream filterInputStream = httpResponse.getInputStream();
        int n = httpResponse.getContentLength();
        String string = httpResponse.getContentEncoding();
        if (string != null && string.indexOf("gzip") >= 0) {
            filterInputStream = new GZIPInputStream((InputStream)filterInputStream, 8192);
        }
        LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(LaunchDescFactory.readBytes(filterInputStream, n), uRL3, uRL2);
        ((InputStream)filterInputStream).close();
        return launchDesc;
    }

    public static LaunchDesc buildDescriptor(String string, String string2, URL uRL, boolean bl) throws BadFieldException, MissingFieldException, JNLParseException {
        URL uRL2 = null;
        if (bl) {
            System.out.println("JNLP Build LaunchDesc jnlp: " + string + ", codebaseStr: " + string2 + ", documentbase: " + uRL);
        }
        try {
            uRL2 = URLUtil.asPathURL((URL)new URL(string2));
            if (bl) {
                System.out.println("   JNLP Codebase (absolute): " + uRL2);
            }
        }
        catch (Exception exception) {
            uRL2 = null;
        }
        if (uRL2 == null) {
            try {
                uRL2 = URLUtil.asPathURL((URL)new URL(URLUtil.getBase((URL)uRL), string2));
                if (bl) {
                    System.out.println("   JNLP Codebase (documentbase+codebase): " + uRL2);
                }
            }
            catch (Exception exception) {
                uRL2 = null;
            }
        }
        if (bl && uRL2 == null) {
            System.out.println("   JNLP Codebase (null)");
        }
        return LaunchDescFactory.buildDescriptor(string, uRL2, uRL, bl);
    }

    public static LaunchDesc buildDescriptor(String string, URL uRL, URL uRL2, boolean bl) throws BadFieldException, MissingFieldException, JNLParseException {
        LaunchDesc launchDesc;
        URL uRL3 = null;
        try {
            uRL3 = new URL(string);
        }
        catch (Exception exception) {
            uRL3 = null;
        }
        if (uRL3 != null) {
            try {
                LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(uRL3, uRL2);
                if (bl) {
                    System.out.println("   JNLP Ref (absolute): " + uRL3.toString());
                }
                return launchDesc2;
            }
            catch (BadFieldException badFieldException) {
                throw badFieldException;
            }
            catch (MissingFieldException missingFieldException) {
                throw missingFieldException;
            }
            catch (JNLParseException jNLParseException) {
                throw jNLParseException;
            }
            catch (Exception exception) {
                if (bl) {
                    System.out.println(exception);
                    exception.printStackTrace();
                }
                uRL3 = null;
            }
        }
        if (uRL != null) {
            try {
                uRL3 = new URL(uRL, string);
            }
            catch (Exception exception) {
                uRL3 = null;
            }
            if (uRL3 != null) {
                try {
                    launchDesc = LaunchDescFactory.buildDescriptor(uRL3, uRL2);
                    if (bl) {
                        System.out.println("   JNLP Ref (codebase + ref): " + uRL3.toString());
                    }
                    return launchDesc;
                }
                catch (BadFieldException badFieldException) {
                    throw badFieldException;
                }
                catch (MissingFieldException missingFieldException) {
                    throw missingFieldException;
                }
                catch (JNLParseException jNLParseException) {
                    throw jNLParseException;
                }
                catch (Exception exception) {
                    if (bl) {
                        System.out.println(exception);
                        exception.printStackTrace();
                    }
                    uRL3 = null;
                }
            }
        }
        if (uRL == null && uRL2 != null) {
            try {
                uRL3 = new URL(URLUtil.getBase((URL)uRL2), string);
            }
            catch (Exception exception) {
                uRL3 = null;
            }
            if (uRL3 != null) {
                try {
                    launchDesc = LaunchDescFactory.buildDescriptor(uRL3, uRL2);
                    if (bl) {
                        System.out.println("   JNLP Ref (documentbase + ref): " + uRL3.toString());
                    }
                    return launchDesc;
                }
                catch (BadFieldException badFieldException) {
                    throw badFieldException;
                }
                catch (MissingFieldException missingFieldException) {
                    throw missingFieldException;
                }
                catch (JNLParseException jNLParseException) {
                    throw jNLParseException;
                }
                catch (Exception exception) {
                    if (bl) {
                        System.out.println(exception);
                        exception.printStackTrace();
                    }
                    uRL3 = null;
                }
            }
        }
        if (bl) {
            System.out.println("   JNLP Ref (...): NULL !");
        }
        return null;
    }

    public static LaunchDesc buildDescriptor(String string) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        FileInputStream fileInputStream = null;
        Object var2_2 = null;
        int n = -1;
        try {
            URL uRL = new URL(string);
            return LaunchDescFactory.buildDescriptor(uRL, null);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (!file.exists() && !Config.isJavaVersionAtLeast14() && malformedURLException.getMessage().indexOf("https") != -1) {
                throw new BadFieldException(ResourceManager.getString((String)"launch.error.badfield.download.https"), "<jnlp>", "https");
            }
            fileInputStream = new FileInputStream(string);
            long l = file.length();
            if (l > 0x100000L) {
                throw new IOException("File too large");
            }
            n = (int)l;
            if (Environment.isImportMode()) {
                String string2 = file.getParent();
                if (Environment.getImportModeCodebaseOverride() == null && string2 != null) {
                    try {
                        URL uRL = new URL("file", null, URLUtil.encodePath((String)string2));
                        Environment.setImportModeCodebaseOverride((String)uRL.toString());
                    }
                    catch (MalformedURLException malformedURLException2) {
                        Trace.ignoredException((Exception)malformedURLException2);
                    }
                }
            }
            return LaunchDescFactory.buildDescriptor(LaunchDescFactory.readBytes(fileInputStream, n), null, null);
        }
    }

    public static LaunchDesc buildInternalLaunchDesc(String string, String string2, String string3) {
        return new LaunchDesc("0.1", null, null, null, null, 1, null, null, 5, null, null, null, null, string3 == null ? string : string3, string2, null, LaunchSelection.createDefaultMatchJRE());
    }

    public static byte[] readBytes(InputStream inputStream, long l) throws IOException {
        byte[] byArray;
        if (l > 0x100000L) {
            throw new IOException("File too large");
        }
        BufferedInputStream bufferedInputStream = null;
        bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        if (l <= 0L) {
            l = 10240L;
        }
        byte[] byArray2 = new byte[(int)l];
        int n = 0;
        int n2 = bufferedInputStream.read(byArray2, n, byArray2.length - n);
        while (n2 != -1) {
            if (byArray2.length == (n += n2)) {
                byArray = new byte[byArray2.length * 2];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                byArray2 = byArray;
            }
            n2 = bufferedInputStream.read(byArray2, n, byArray2.length - n);
        }
        bufferedInputStream.close();
        inputStream.close();
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }
}

