/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.cookie.DeployCookieSelector;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.net.proxy.DeployProxySelector;
import com.sun.deploy.net.proxy.StaticProxyManager;
import com.sun.deploy.panel.ControlPanel;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.ConsoleController;
import com.sun.deploy.util.ConsoleHelper;
import com.sun.deploy.util.ConsoleTraceListener;
import com.sun.deploy.util.ConsoleWindow;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.DialogListener;
import com.sun.deploy.util.FileTraceListener;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.LoggerTraceListener;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.SocketTraceListener;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.TraceListener;
import com.sun.javaws.BrowserSupport;
import com.sun.javaws.CacheUpdateHelper;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.Globals;
import com.sun.javaws.JAuthenticator;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.Launcher;
import com.sun.javaws.OperaSupport;
import com.sun.javaws.exceptions.CacheAccessException;
import com.sun.javaws.exceptions.CouldNotLoadArgumentException;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.InvalidArgumentException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.security.AppContextUtil;
import com.sun.javaws.ui.JavawsSysRun;
import com.sun.javaws.ui.LaunchErrorDialog;
import com.sun.javaws.ui.SplashScreen;
import com.sun.javaws.util.JavawsConsoleController;
import com.sun.javaws.util.JavawsDialogListener;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.JnlpLookupStub;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import javax.jnlp.ServiceManager;
import javax.net.ssl.SSLException;

public class Main {
    private static boolean _isViewer = false;
    private static boolean _launchingAllowed = false;
    private static boolean _environmentInitialized = false;
    private static ThreadGroup _systemTG;
    private static ThreadGroup _securityTG;
    private static ClassLoader _secureContextClassLoader;
    private static ThreadGroup _launchTG;
    private static String _tempfile;
    private static DataInputStream _tckStream;
    private static boolean _verbose;
    private static boolean _quietOnly;
    private static boolean uninstall;

    public static void main(final String[] stringArray) {
        PerfLogger.setStartTime((String)"JavaWebStart main started");
        _secureContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JNLPClassLoader.createClassLoader());
        String string = System.getProperty("java.protocol.handler.pkgs");
        if (string != null) {
            System.setProperty("java.protocol.handler.pkgs", string + "|com.sun.javaws.net.protocol");
        } else {
            System.setProperty("java.protocol.handler.pkgs", "com.sun.javaws.net.protocol");
        }
        Toolkit.getDefaultToolkit();
        Main.initializeThreadGroups();
        new Thread(_securityTG, new Runnable(){

            public void run() {
                AppContextUtil.createSecurityAppContext();
                Thread.currentThread().setContextClassLoader(Main.getSecureContextClassLoader());
                try {
                    Main.continueInSecureThread(stringArray);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                Trace.flush();
            }
        }, "Java Web Start Main Thread").start();
    }

    public static void continueInSecureThread(String[] stringArray) {
        _launchingAllowed = Config.isConfigValid();
        String[] stringArray2 = Globals.parseOptions(stringArray);
        stringArray2 = Main.parseArgs(stringArray2);
        if (!Globals.isSilentMode() || _quietOnly) {
            DeployUIManager.setLookAndFeel();
        }
        if (stringArray2.length > 0) {
            _tempfile = stringArray2[stringArray2.length - 1];
        } else if (!(uninstall || _isViewer || Environment.isSystemCacheMode())) {
            LaunchErrorDialog.show(null, new InvalidArgumentException(stringArray), true);
        }
        if (!_isViewer) {
            Main.initTrace();
        }
        if (Config.getSystemCacheDirectory() == null && Environment.isSystemCacheMode()) {
            LaunchErrorDialog.show(null, new CacheAccessException(true), true);
        }
        if (Environment.isImportMode() && !Cache.isCacheEnabled()) {
            if (Globals.isSilentMode()) {
                try {
                    Main.systemExit(0);
                }
                catch (ExitException exitException) {
                    Trace.println((String)("systemExit: " + exitException), (TraceLevel)TraceLevel.BASIC);
                    Trace.ignoredException((Exception)exitException);
                }
            } else {
                LaunchErrorDialog.show(null, new CacheAccessException(Environment.isSystemCacheMode(), true), true);
            }
        }
        Config.validateSystemCacheDirectory();
        if (Cache.canWrite() || _isViewer) {
            Main.setupBrowser();
            JnlpxArgs.verify();
            Main.initializeExecutionEnvironment();
            if (uninstall) {
                Main.uninstallCache(stringArray2.length > 0 ? stringArray2[0] : null);
            } else {
                if (DeployOfflineManager.isGlobalOffline()) {
                    SplashScreen.hide();
                    try {
                        if (!DeployOfflineManager.askUserGoOnline((URL)new URL("http://java.sun.com"))) {
                            JnlpxArgs.SetIsOffline();
                            DeployOfflineManager.setForcedOffline((boolean)true);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (Environment.isSystemCacheMode()) {
                    CacheUpdateHelper.systemUpdateCheck();
                } else if (Config.getBooleanProperty((String)"deployment.javaws.cache.update") && CacheUpdateHelper.updateCache()) {
                    Config.setBooleanProperty((String)"deployment.javaws.cache.update", (boolean)false);
                    Config.storeIfDirty();
                }
                if (!_isViewer) {
                    if (Globals.TCKHarnessRun) {
                        Main.tckprintln("Java Started");
                    }
                    if (stringArray2.length > 0) {
                        Main.launchApp(stringArray2, true);
                    }
                } else {
                    if (stringArray2.length > 0) {
                        JnlpxArgs.removeArgumentFile(stringArray2[0]);
                    }
                    PerfLogger.setEndTime((String)"Calling Application viewer");
                    PerfLogger.outputLog();
                    try {
                        String[] stringArray3 = new String[]{"-viewer"};
                        Main.launchJavaControlPanel(stringArray3);
                    }
                    catch (Exception exception) {
                        LaunchErrorDialog.show(null, exception, true);
                    }
                }
            }
        } else {
            LaunchErrorDialog.show(null, new CacheAccessException(Environment.isSystemCacheMode()), true);
        }
        Trace.flush();
        SplashScreen.hide();
    }

    public static void launchApp(String[] stringArray, boolean bl) {
        Object object;
        if (stringArray.length > 1) {
            JnlpxArgs.removeArgumentFile(stringArray[stringArray.length - 1]);
            LaunchErrorDialog.show(null, new InvalidArgumentException(stringArray), bl);
            return;
        }
        LaunchDesc launchDesc = null;
        try {
            object = JREInfo.getHomeJRE();
            if (object == null) {
                throw new ExitException(new Exception("Internal Error: no running JRE"), 3);
            }
            launchDesc = LaunchDescFactory.buildDescriptor(stringArray[0]);
        }
        catch (IOException iOException) {
            JNLPException jNLPException = null;
            JnlpxArgs.removeArgumentFile(stringArray[0]);
            jNLPException = new CouldNotLoadArgumentException(stringArray[0], iOException);
            if (Config.isJavaVersionAtLeast14() && (iOException instanceof SSLException || iOException.getMessage() != null && iOException.getMessage().toLowerCase().indexOf("https") != -1)) {
                try {
                    jNLPException = new FailedDownloadingResourceException(new URL(stringArray[0]), null, iOException);
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.ignoredException((Exception)malformedURLException);
                }
            }
            LaunchErrorDialog.show(null, jNLPException, bl);
            return;
        }
        catch (Exception exception) {
            JnlpxArgs.removeArgumentFile(stringArray[0]);
            LaunchErrorDialog.show(null, exception, bl);
            return;
        }
        Environment.setImportModeCodebase((URL)launchDesc.getCodebase());
        if (launchDesc.getLaunchType() == 5) {
            JnlpxArgs.removeArgumentFile(stringArray[0]);
            object = launchDesc.getInternalCommand();
            String[] stringArray2 = object != null && !((String)object).equals("player") && !((String)object).equals("viewer") ? new String[]{"-tab", launchDesc.getInternalCommand()} : new String[]{"-viewer"};
            Main.launchJavaControlPanel(stringArray2);
        } else if (_launchingAllowed) {
            new Launcher(launchDesc).launch(stringArray, bl);
        } else {
            LaunchErrorDialog.show(null, new LaunchDescException(launchDesc, ResourceManager.getString((String)"enterprize.cfg.mandatory", (String)Config.getEnterprizeString()), null), bl);
        }
    }

    static void importApp(String string) {
        String[] stringArray = new String[]{string};
        boolean bl = Environment.isImportMode();
        Environment.setImportMode((boolean)true);
        boolean bl2 = Globals.isSilentMode();
        Globals.setSilentMode(true);
        boolean bl3 = Globals.isShortcutMode();
        Globals.setCreateShortcut(true);
        Main.launchApp(stringArray, false);
        Environment.setImportMode((boolean)bl);
        Globals.setSilentMode(bl2);
        Globals.setCreateShortcut(bl3);
    }

    private static void launchJavaControlPanel(String[] stringArray) {
        SplashScreen.hide();
        ControlPanel.main((String[])stringArray);
    }

    private static void uninstallCache(String string) {
        int n = -1;
        try {
            n = Main.uninstall(string);
        }
        catch (Exception exception) {
            LaunchErrorDialog.show(null, exception, !Globals.isSilentMode() || _quietOnly);
        }
        _tempfile = null;
        try {
            Main.systemExit(n);
        }
        catch (ExitException exitException) {
            Trace.println((String)("systemExit: " + exitException), (TraceLevel)TraceLevel.BASIC);
            Trace.ignoredException((Exception)exitException);
        }
    }

    private static Date parseDate(String string) {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy hh:mm a");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            ParseException parseException2 = new ParseException(parseException.getMessage() + " " + ResourceManager.getString((String)"launch.error.dateformat"), parseException.getErrorOffset());
            LaunchErrorDialog.show(null, parseException2, true);
        }
        return date;
    }

    private static String[] parseArgs(String[] stringArray) {
        String[] stringArray2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            Date date;
            if (!stringArray[i].startsWith("-")) {
                arrayList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-offline")) {
                JnlpxArgs.SetIsOffline();
                DeployOfflineManager.setForcedOffline((boolean)true);
                continue;
            }
            if (stringArray[i].equals("-online") || stringArray[i].equals("-Xnosplash")) continue;
            if (stringArray[i].equals("-installer")) {
                Environment.setInstallMode((boolean)true);
                continue;
            }
            if (stringArray[i].equals("-uninstall") || stringArray[i].equals("-Xclearcache")) {
                uninstall = true;
                Environment.setInstallMode((boolean)true);
                Environment.setImportMode((boolean)true);
                continue;
            }
            if (stringArray[i].equals("-import")) {
                Environment.setImportMode((boolean)true);
                continue;
            }
            if (stringArray[i].equals("-quiet")) {
                _quietOnly = true;
                Globals.setSilentMode(true);
                continue;
            }
            if (stringArray[i].equals("-silent")) {
                Globals.setSilentMode(true);
                continue;
            }
            if (stringArray[i].equals("-reverse")) {
                Globals.setReverseMode(true);
                continue;
            }
            if (stringArray[i].equals("-javafx")) {
                Globals.setJavaFxMode(true);
                continue;
            }
            if (stringArray[i].equals("-shortcut")) {
                Globals.setCreateShortcut(true);
                continue;
            }
            if (stringArray[i].equals("-association")) {
                Globals.setCreateAssoc(true);
                continue;
            }
            if (stringArray[i].equals("-prompt")) {
                Globals.setShowPrompts(true);
                continue;
            }
            if (stringArray[i].equals("-codebase")) {
                if (i + 1 >= stringArray.length) continue;
                stringArray2 = stringArray[++i];
                try {
                    new URL((String)stringArray2);
                }
                catch (MalformedURLException malformedURLException) {
                    LaunchErrorDialog.show(null, malformedURLException, true);
                }
                Environment.setImportModeCodebaseOverride((String)stringArray2);
                continue;
            }
            if (stringArray[i].equals("-timestamp")) {
                if (i + 1 >= stringArray.length || (date = Main.parseDate((String)(stringArray2 = stringArray[++i]))) == null) continue;
                Environment.setImportModeTimestamp((Date)date);
                continue;
            }
            if (stringArray[i].equals("-expiration")) {
                if (i + 1 >= stringArray.length || (date = Main.parseDate((String)(stringArray2 = stringArray[++i]))) == null) continue;
                Environment.setImportModeExpiration((Date)date);
                continue;
            }
            if (stringArray[i].equals("-system")) {
                Environment.setSystemCacheMode((boolean)true);
                continue;
            }
            if (stringArray[i].equals("-secure")) {
                Globals.setSecureMode(true);
                continue;
            }
            if (stringArray[i].equals("-open") || stringArray[i].equals("-print")) {
                if (i + 1 >= stringArray.length) continue;
                stringArray2 = new String[]{stringArray[i++], stringArray[i]};
                Globals.setApplicationArgs(stringArray2);
                SingleInstanceManager.setActionName((String)stringArray2[0]);
                SingleInstanceManager.setOpenPrintFilePath((String)stringArray2[1]);
                continue;
            }
            if (stringArray[i].equals("-viewer")) {
                _isViewer = true;
                continue;
            }
            if (stringArray[i].equals("-verbose")) {
                _verbose = true;
                continue;
            }
            Trace.println((String)("unsupported option: " + stringArray[i]), (TraceLevel)TraceLevel.BASIC);
        }
        stringArray2 = new String[arrayList.size()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = (String)arrayList.get(i);
        }
        return stringArray2;
    }

    private static void initTrace() {
        Object object;
        FileTraceListener fileTraceListener;
        Object object2;
        Trace.redirectStdioStderr();
        Trace.resetTraceLevel();
        Trace.setInitialTraceLevel();
        if (_verbose || Globals.TraceBasic) {
            Trace.setBasicTrace((boolean)true);
        }
        if (_verbose || Globals.TraceNetwork) {
            Trace.setNetTrace((boolean)true);
        }
        if (_verbose || Globals.TraceCache) {
            Trace.setCacheTrace((boolean)true);
        }
        if (_verbose || Globals.TraceSecurity) {
            Trace.setSecurityTrace((boolean)true);
        }
        if (_verbose || Globals.TraceExtensions) {
            Trace.setExtTrace((boolean)true);
        }
        if (_verbose || Globals.TraceTemp) {
            Trace.setTempTrace((boolean)true);
        }
        if (Config.getProperty((String)"deployment.console.startup.mode").equals("SHOW") && !Globals.isHeadless()) {
            object2 = JavawsConsoleController.getInstance();
            fileTraceListener = new ConsoleTraceListener((ConsoleController)object2);
            object = ConsoleWindow.create((ConsoleController)object2);
            ((JavawsConsoleController)object2).setConsole((ConsoleWindow)object);
            if (fileTraceListener != null) {
                fileTraceListener.setConsole(object);
                Trace.addTraceListener((TraceListener)fileTraceListener);
                fileTraceListener.print(ConsoleHelper.displayVersion() + "\n");
                fileTraceListener.print(ConsoleHelper.displayHelp());
            }
        }
        if ((object2 = Main.initSocketTrace()) != null) {
            Trace.addTraceListener((TraceListener)object2);
        }
        if ((fileTraceListener = Main.initFileTrace()) != null) {
            Trace.addTraceListener((TraceListener)fileTraceListener);
        }
        if (Config.isJavaVersionAtLeast14() && Config.getBooleanProperty((String)"deployment.log")) {
            object = null;
            try {
                File file;
                object = Config.getProperty((String)"deployment.javaws.logFileName");
                File file2 = new File(Config.getLogDirectory());
                if (object != null && object != "") {
                    file = new File((String)object);
                    if (file.isDirectory()) {
                        object = "";
                    } else {
                        file2 = file.getParentFile();
                        if (file2 != null) {
                            file2.mkdirs();
                        }
                    }
                }
                if (object == "") {
                    file2.mkdirs();
                    file = Trace.createTempFile((String)"javaws", (String)".log", (File)file2);
                    object = file.getPath();
                }
                file = null;
                File file3 = new File((String)object);
                if (file3.exists() && file3.canWrite() || !file3.exists() && file2.canWrite()) {
                    file = new LoggerTraceListener("com.sun.deploy", (String)object);
                }
                if (file != null) {
                    file.getLogger().setLevel(Level.ALL);
                    JavawsConsoleController.getInstance().setLogger(file.getLogger());
                    Trace.addTraceListener((TraceListener)file);
                }
            }
            catch (Exception exception) {
                Trace.println((String)("can not create log file in directory: " + Config.getLogDirectory()), (TraceLevel)TraceLevel.BASIC);
            }
        }
    }

    private static FileTraceListener initFileTrace() {
        if (Config.getBooleanProperty((String)"deployment.trace")) {
            File file = null;
            String string = Config.getProperty((String)"deployment.user.logdir");
            String string2 = Config.getProperty((String)"deployment.javaws.traceFileName");
            try {
                if (string2 != null && string2 != "" && string2.compareToIgnoreCase("TEMP") != 0) {
                    file = new File(string2);
                    if (!file.isDirectory()) {
                        int n = string2.lastIndexOf(File.separator);
                        if (n != -1) {
                            string = string2.substring(0, n);
                        }
                    } else {
                        file = null;
                    }
                }
                File file2 = new File(string);
                file2.mkdirs();
                if (file == null) {
                    file = Trace.createTempFile((String)"javaws", (String)".trace", (File)file2);
                }
                if (file != null && (file.exists() && file.canWrite() || !file.exists() && file2.canWrite())) {
                    return new FileTraceListener(file, true);
                }
            }
            catch (Exception exception) {
                Trace.println((String)("cannot create trace file in Directory: " + string), (TraceLevel)TraceLevel.BASIC);
            }
        }
        return null;
    }

    private static SocketTraceListener initSocketTrace() {
        if (Globals.LogToHost != null) {
            String string;
            String string2 = Globals.LogToHost;
            String string3 = null;
            int n = -1;
            int n2 = 0;
            int n3 = 0;
            if (string2.charAt(0) == '[' && (n3 = string2.indexOf(1, 93)) != -1) {
                n2 = 1;
            } else {
                n3 = string2.indexOf(":");
            }
            string3 = string2.substring(n2, n3);
            if (string3 == null) {
                return null;
            }
            try {
                string = string2.substring(string2.lastIndexOf(58) + 1);
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n < 0) {
                return null;
            }
            string = new SocketTraceListener(string3, n);
            if (string != null) {
                Socket socket = string.getSocket();
                if (Globals.TCKResponse && socket != null) {
                    try {
                        _tckStream = new DataInputStream(socket.getInputStream());
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                    }
                }
            }
            return string;
        }
        return null;
    }

    private static int uninstall(String string) {
        if (string == null) {
            Trace.println((String)"Uninstall all!", (TraceLevel)TraceLevel.BASIC);
            Main.uninstallAll();
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("Cache Clear Success");
            }
        } else {
            Trace.println((String)("Uninstall: " + string), (TraceLevel)TraceLevel.BASIC);
            LaunchDesc launchDesc = null;
            try {
                launchDesc = LaunchDescFactory.buildDescriptor(string);
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
            catch (JNLPException jNLPException) {
                Trace.ignoredException((Exception)jNLPException);
            }
            if (launchDesc != null) {
                Object object;
                Object object2;
                String string2;
                if (Globals.showPrompts()) {
                    string2 = launchDesc.getInformation().getTitle();
                    object2 = ResourceManager.getString((String)"uninstall.app.prompt.title");
                    object = ResourceManager.getString((String)"uninstall.app.prompt.message", (String)string2);
                    if (UIFactory.showConfirmDialog(null, (AppInfo)launchDesc.getAppInfo(), (String)object, (String)object2) != 0) {
                        Trace.println((String)"Uninstall canceled by user.", (TraceLevel)TraceLevel.BASIC);
                        return 0;
                    }
                }
                string2 = null;
                string2 = launchDesc.isInstaller() || launchDesc.isLibrary() ? Cache.getLocalApplicationProperties((String)string) : Cache.getLocalApplicationProperties((URL)launchDesc.getCanonicalHome());
                if (string2 != null) {
                    object2 = null;
                    try {
                        object2 = new File(string);
                        if (!((File)object2).exists()) {
                            object = new URL(string);
                            object2 = DownloadEngine.getCachedFile((URL)object);
                        }
                    }
                    catch (Exception exception) {
                        Trace.ignored((Throwable)exception);
                    }
                    if (object2 != null && ((File)object2).exists()) {
                        CacheUtil.remove((File)object2, launchDesc);
                    }
                    if (Globals.TCKHarnessRun) {
                        Main.tckprintln("Cache Clear Success");
                    }
                    return 0;
                }
            }
            Trace.println((String)"Error uninstalling!", (TraceLevel)TraceLevel.BASIC);
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("Cache Clear Failed");
            }
            if (!Globals.isSilentMode() || _quietOnly) {
                SplashScreen.hide();
                UIFactory.showErrorDialog(null, (String)ResourceManager.getMessage((String)"uninstall.failedMessage"), (String)ResourceManager.getMessage((String)"uninstall.failedMessageTitle"));
            }
        }
        return 0;
    }

    private static void uninstallAll() {
        CacheUtil.remove();
    }

    private static void setupBrowser() {
        if (Config.getBooleanProperty((String)"deployment.capture.mime.types")) {
            Main.setupNS6();
            Main.setupOpera();
            Config.setBooleanProperty((String)"deployment.capture.mime.types", (boolean)false);
        }
    }

    private static void setupOpera() {
        OperaSupport operaSupport = BrowserSupport.getInstance().getOperaSupport();
        if (operaSupport != null && operaSupport.isInstalled()) {
            operaSupport.enableJnlp(new File(Config.getInstance().getSystemJavawsPath()), Config.getBooleanProperty((String)"deployment.update.mime.types"));
        }
    }

    private static void setupNS6() {
        String string = null;
        string = BrowserSupport.getInstance().getNS6MailCapInfo();
        String string2 = "user_pref(\"browser.helperApps.neverAsk.openFile\", \"application%2Fx-java-jnlp-file\");\n";
        File file = null;
        String string3 = Config.getInstance().getMozillaUserProfileDirectory();
        if (string3 != null) {
            file = new File(string3 + File.separator + "prefs.js");
        }
        if (file == null) {
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            String string4 = null;
            fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string5 = "";
            boolean bl = true;
            boolean bl2 = string != null;
            block8: while (true) {
                try {
                    while (true) {
                        if ((string4 = bufferedReader.readLine()) == null) {
                            ((InputStream)fileInputStream).close();
                            break block8;
                        }
                        string5 = string5 + string4 + "\n";
                        if (string4.indexOf("x-java-jnlp-file") != -1) {
                            bl = false;
                        }
                        if (string == null || string4.indexOf(".mime.types") == -1) continue;
                        bl2 = false;
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                    continue;
                }
                break;
            }
            if (!bl && !bl2) {
                return;
            }
            if (bl) {
                string5 = string5 + string2;
            }
            if (string != null && bl2) {
                string5 = string5 + string;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                fileOutputStream.write(string5.getBytes());
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.ignoredException((Exception)fileNotFoundException);
            String string6 = "";
            if (string != null) {
                string6 = string6 + string;
            }
            string6 = string6 + string2;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(string6.getBytes());
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    public static void initializeExecutionEnvironment() {
        Object object;
        if (_environmentInitialized) {
            return;
        }
        _environmentInitialized = true;
        boolean bl = Config.getOSName().indexOf("Windows") != -1;
        boolean bl2 = Config.isJavaVersionAtLeast15();
        Environment.setUserAgent((String)Globals.getUserAgent());
        if (bl) {
            if (bl2) {
                com.sun.deploy.services.ServiceManager.setService((int)33024);
            } else {
                com.sun.deploy.services.ServiceManager.setService((int)16640);
            }
        } else if (bl2) {
            com.sun.deploy.services.ServiceManager.setService((int)36864);
        } else {
            com.sun.deploy.services.ServiceManager.setService((int)20480);
        }
        Properties properties = System.getProperties();
        properties.put("http.auth.serializeRequests", "true");
        if (Config.isJavaVersionAtLeast14()) {
            if (Config.installDeployRMIClassLoaderSpi()) {
                properties.put("java.rmi.server.RMIClassLoaderSpi", "com.sun.jnlp.JNLPRMIClassLoaderSpi");
            }
            if ((object = (String)properties.get("java.protocol.handler.pkgs")) != null) {
                properties.put("java.protocol.handler.pkgs", (String)object + "|com.sun.deploy.net.protocol");
            } else {
                properties.put("java.protocol.handler.pkgs", "com.sun.deploy.net.protocol");
            }
        }
        properties.setProperty("javawebstart.version", Globals.getComponentName());
        try {
            DeployProxySelector.reset();
            DeployCookieSelector.reset();
        }
        catch (Throwable throwable) {
            StaticProxyManager.reset();
        }
        DeployOfflineManager.reset();
        if (Config.getBooleanProperty((String)"deployment.security.authenticator")) {
            object = JAuthenticator.getInstance(null);
            Authenticator.setDefault((Authenticator)object);
        }
        ServiceManager.setServiceManagerStub(new JnlpLookupStub());
        Config.setupPackageAccessRestriction();
        UIFactory.setDialogListener((DialogListener)new JavawsDialogListener());
        if (properties.get("https.protocols") == null) {
            object = new StringBuffer();
            if (Config.getBooleanProperty((String)"deployment.security.TLSv1")) {
                ((StringBuffer)object).append("TLSv1");
            }
            if (Config.getBooleanProperty((String)"deployment.security.SSLv3")) {
                if (((StringBuffer)object).length() != 0) {
                    ((StringBuffer)object).append(",");
                }
                ((StringBuffer)object).append("SSLv3");
            }
            if (Config.getBooleanProperty((String)"deployment.security.SSLv2Hello")) {
                if (((StringBuffer)object).length() != 0) {
                    ((StringBuffer)object).append(",");
                }
                ((StringBuffer)object).append("SSLv2Hello");
            }
            properties.put("https.protocols", ((StringBuffer)object).toString());
        }
        object = new JVMParameters();
        long l = JnlpxArgs.getMaxHeapSize();
        if (l <= 0L) {
            l = JVMParameters.getDefaultHeapSize();
        }
        object.setMaxHeapSize(l);
        l = JnlpxArgs.getInitialHeapSize();
        if (l > 0L && l != JVMParameters.getDefaultHeapSize()) {
            object.parse("-Xms" + JVMParameters.unparseMemorySpec((long)l));
        }
        object.parseTrustedOptions(JnlpxArgs.getVMArgs());
        object.setDefault(true);
        JVMParameters.setRunningJVMParameters((JVMParameters)object);
        Trace.println((String)("Running JVMParams: " + object + "\n\t-> " + JVMParameters.getRunningJVMParameters()), (TraceLevel)TraceLevel.BASIC);
    }

    public static void systemExit(int n) throws ExitException {
        try {
            JnlpxArgs.removeArgumentFile(_tempfile);
            SplashScreen.hide();
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
        Trace.flush();
        if (Environment.isJavaPlugin()) {
            ExitException exitException = new ExitException(new RuntimeException("exit(" + n + ")"), 4);
            throw exitException;
        }
        System.exit(n);
    }

    public static boolean isViewer() {
        return _isViewer;
    }

    public static final ThreadGroup getLaunchThreadGroup() {
        return _launchTG;
    }

    public static final ThreadGroup getSecurityThreadGroup() {
        return _securityTG;
    }

    public static final ClassLoader getSecureContextClassLoader() {
        return _secureContextClassLoader;
    }

    private static void initializeThreadGroups() {
        if (_securityTG == null) {
            _systemTG = Thread.currentThread().getThreadGroup();
            while (_systemTG.getParent() != null) {
                _systemTG = _systemTG.getParent();
            }
            _securityTG = new ThreadGroup(_systemTG, "javawsSecurityThreadGroup");
            DeploySysRun.setOverride((DeploySysRun)new JavawsSysRun());
            _launchTG = new ThreadGroup(_systemTG, "javawsApplicationThreadGroup");
        }
    }

    public static synchronized void tckprintln(String string) {
        long l = System.currentTimeMillis();
        Trace.println((String)("##TCKHarnesRun##:" + l + ":" + Runtime.getRuntime().hashCode() + ":" + Thread.currentThread() + ":" + string));
        if (_tckStream != null) {
            try {
                while (_tckStream.readLong() < l) {
                }
            }
            catch (IOException iOException) {
                System.err.println("Warning:Exceptions occurred, while logging to logSocket");
                iOException.printStackTrace(System.err);
            }
        }
        Trace.flush();
    }

    static {
        _tempfile = null;
        _tckStream = null;
        _verbose = false;
        _quietOnly = false;
        uninstall = false;
    }
}

