<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Comparator Interface
 * (based on java.util.Comparator)
 * 
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id:$
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Util;

require_once 'Commons/Lang/Object.php';
/*
use Commons::Lang::Object;
*/

/**
 * Comparator
 *
 *
 * @category   PHP
 * @package    Commons.Util
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.3
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
interface Commons_Util_Comparator {
//interface Comparator {
	
	/**
	 * Compares two objects
	 * 
	 * @param object $o1 the first object
	 * @param object $o2 the second object
	 * @return int the comparison
	 */
	public function compare($o1, $o2);
	
	
	/**
	 * @param object $obj The object
	 * @return bool true if it is a Comparator that imposes the same order
	 */
	public function equals($obj);
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>