<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Object Utilities
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: ObjectUtils.php 350 2008-08-31 07:16:23Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.3
 */

//namespace Commons::Lang;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/StringBuffer.php';
require_once 'Commons/Lang/System.php';
/*
use Commons::Lang::Object;
use Commons::Lang::StringBuffer;
use Commons::Lang::System;
*/
/**
 * ObjectUtils
 *
 *
 * @category   PHP
 * @package    Commons.Lang
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.3
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.3
 */
class Commons_Lang_ObjectUtils extends Commons_Lang_Object {
	
	private static $_instance = null;
	

	/**
	 * Constructor
	 */
	public function Commons_Lang_ObjectUtils() {
		parent::__construct();
	}
	
	
	public function __destruct() {
	}
	
	
	public static function getInstance() {
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		
		return self::$_instance;
	}
	
	
	public static function appendIdentityToString($buffer, $object) {
		if (is_null($object)) {
			return null;
		}
		if (is_null($buffer)) {
			$buffer = new Commons_Lang_StringBuffer();
		}
		return $buffer
			->append(get_class($object) . '@')
			->append(Commons_Lang_System::identityHashCode($object));
	}

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>