<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Property Utilities
 * (based on org.apache.commons.beanutils.PropertyUtils)
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: PropertyUtils.php 293 2008-04-15 13:13:20Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.2
 */

//namespace Commons::BeanUtils;

require_once 'Commons/Lang/Object.php';
/*
use Commons::Lang::Object;
*/

/**
 * PropertyUtils
 *
 *
 * @category   PHP
 * @package    Commons.BeanUtils
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.3
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.2
 */
class Commons_BeanUtils_PropertyUtils extends Commons_Lang_Object {

	/**
	 * The delimiter that preceeds the zero-relative subscript for an
	 * indexed reference.
	 */
	const INDEXED_DELIM = '[';

	/**
	 * The delimiter that follows the zero-relative subscript for an
	 * indexed reference.
	 */
	const INDEXED_DELIM2 = ']';

	/**
	 * The delimiter that preceeds the key of a mapped property.
	 */
	const MAPPED_DELIM = '(';
	
	/**
	 * The delimiter that follows the key of a mapped property.
	 */
	const MAPPED_DELIM2 = ')';
	
	/**
	 * The delimiter that separates the components of a nested reference.
	 */
	const NESTED_DELIM = '.';
	

	public function Commons_BeanUtils_PropertyUtils() {
		parent::__construct();
	}
	
	
	public function __destruct() {
	}
	
	// TODO

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>