package org.phosphoresce.dbbrowser.config;

import java.io.Serializable;

import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * DatabaseBrowserŋߗpf[^x[XRlNVݒێNX<br>
 * <br>
 * NXSerializableC^tF[XAi\ȃtB[ĥ݂ێ܂B<br>
 * OIɉis\ȃtB[hێꍇ́A͕ۑɑΏۂƂȂ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/10/08	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserRecentConnectionConfig implements Serializable {

	/** m[h */
	public static final String NODE_NAME = "recentConnection";

	/** ŋߗpf[^x[Xڑݒ */
	private DatabaseBrowserConnectionConfig connectionConfig;

	/**
	 * RXgN^<br>
	 */
	DatabaseBrowserRecentConnectionConfig() {
		super();
		initialize();
	}

	/**
	 * RXgN^<br>
	 * @param root [gm[h
	 */
	DatabaseBrowserRecentConnectionConfig(Node root) {
		super();
		initialize();
		load(root);
	}

	/**
	 * ێ܂B<br>
	 */
	private void initialize() {
		connectionConfig = new DatabaseBrowserConnectionConfig();
	}

	/**
	 * w肳ꂽhLg̃[gGgɑ΂Ďgێm[hۑ܂B<br>
	 * @param document DocumentIuWFNg
	 * @param root [gm[h
	 */
	void save(Document document, Node root) {
		Node node = root.appendChild(document.createElement(NODE_NAME));

		getConnectionConfig().save(document, node);
	}

	/**
	 * w肳ꂽm[hǂݍݎg̃tB[hɔf܂B<br>
	 * @param root [gm[h
	 */
	void load(Node root) {
		NodeList nodeList = root.getChildNodes();

		initialize();

		for (int i = 0; i <= nodeList.getLength() - 1; i++) {
			Node node = nodeList.item(i);
			if (DatabaseBrowserConnectionConfig.NODE_NAME.equals(node.getNodeName())) {
				connectionConfig = new DatabaseBrowserConnectionConfig(node);
			}
		}
	}

	/**
	 * ŋߗpf[^x[Xڑݒ擾܂B<br>
	 * @return ŋߗpf[^x[Xڑݒ
	 */
	public DatabaseBrowserConnectionConfig getConnectionConfig() {
		if (connectionConfig == null) {
			connectionConfig = new DatabaseBrowserConnectionConfig();
		}
		return connectionConfig;
	}

	/**
	 * ŋߗpf[^x[Xڑݒݒ肵܂B<br>
	 * @param connectionConfig ŋߗpf[^x[Xڑݒ
	 */
	public void setConnectionConfig(DatabaseBrowserConnectionConfig connectionConfig) {
		this.connectionConfig = connectionConfig;
	}

	/**
	 * ŋߗpf[^x[Xڑݒݒ肵܂B<br>
	 * @param config ŋߗpf[^x[Xڑݒ
	 */
	public void setConnectionConfig(DatabaseConfig config) {
		this.connectionConfig = new DatabaseBrowserConnectionConfig(config);
	}

	/**
	 * NX𕶎Ŏ擾܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("DatabaseBrowserRecentConnectionConfig{");
		buffer.append("connectionConfig=");
		buffer.append(getConnectionConfig());
		buffer.append("}");
		return buffer.toString();
	}
}
