package org.phosphoresce.dbbrowser.gui.panel.querymanage;

import java.awt.Dimension;

import javax.swing.DefaultListModel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.core.DatabaseError;
import org.phosphoresce.commons.eswing.EList;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * NGGfB^G[XgyC<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/20	Kitagawa		VK쐬
 *-->
 */
public final class QueryManageErrorListPane extends EScrollPane implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static QueryManageErrorListPane instance = null;

	/** G[Xg */
	private EList errorList = null;

	/**
	 * RXgN^<br>
	 */
	public QueryManageErrorListPane() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static QueryManageErrorListPane instance() {
		if (instance == null) {
			instance = new QueryManageErrorListPane();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		clearError();
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		this.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		this.setViewportView(getErrorList());
		this.setSize(new Dimension(600, 400));
		this.setBorder(new EmptyBorder(0, 0, 0, 0));
	}

	/**
	 * G[Xg擾܂B<br>
	 * @return G[Xg
	 */
	private EList getErrorList() {
		if (errorList == null) {
			errorList = new EList();
			errorList.setModel(new DefaultListModel());
		}
		return errorList;
	}

	/**
	 * G[ׂăNA܂B<br>
	 */
	public void clearError() {
		DefaultListModel model = (DefaultListModel) getErrorList().getModel();
		model.removeAllElements();
	}

	/**
	 * G[ǉ܂B<br>
	 * @param error DatabaseErrorIuWFNg
	 */
	public void addError(DatabaseError error) {
		if (error == null) {
			return;
		}
		DefaultListModel model = (DefaultListModel) getErrorList().getModel();
		if (error.isSQLException()) {
			model.addElement(error.getErrorMessage() + " (errorCode=" + error.getErrorCode() + ")");
		} else {
			model.addElement(error.getErrorMessage());
		}
	}

	/**
	 * G[ǉ܂B<br>
	 * @param errors DatabaseErrorIuWFNg
	 */
	public void addError(DatabaseError[] errors) {
		if (errors == null) {
			return;
		}
		for (int i = 0; i <= errors.length - 1; i++) {
			addError(errors[i]);
		}
	}
}
