package org.phosphoresce.dbbrowser.gui.panel.querymanage;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.ESplitPane;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.common.component.CatalogSchemaTableListPanel;

/**
 * NGGfB^ҏWR|[lgZbgyC<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/18	Kitagawa		VK쐬
 *-->
 */
public final class QueryManageEditorPane extends EPanel implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static QueryManageEditorPane instance = null;

	/** NGsZbgpl */
	private ESplitPane queryManageSetPanel = null;

	/** e[uXgpl */
	private CatalogSchemaTableListPanel catalogSchemaTableListPanel = null;

	/** NGҏWʃZbgpl */
	private ESplitPane queryExecuteSetPanel = null;

	/** NGʃG[Zbgpl */
	private ESplitPane queryManageResultSetPanel = null;

	/**
	 * RXgN^<br>
	 */
	public QueryManageEditorPane() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static QueryManageEditorPane instance() {
		if (instance == null) {
			instance = new QueryManageEditorPane();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		getCatalogSchemaTableListPanel().refresh();
		QueryManageTextPane.instance().refresh();
		QueryManageResultTablePane.instance().refresh();
		QueryManageErrorListPane.instance().refresh();
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 1;
		gridBagConstraints1.weightx = 1.0;
		gridBagConstraints1.weighty = 1.0;
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.fill = GridBagConstraints.BOTH;
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.weightx = 1.0;
		gridBagConstraints.weighty = 0.0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(561, 387));
		this.add(QueryManageButtonPane.instance(), gridBagConstraints);
		this.add(getQueryManageSetPanel(), gridBagConstraints1);
	}

	/**
	 * NGsZbgpl擾܂B<br>
	 * @return NGsZbgpl
	 */
	public ESplitPane getQueryManageSetPanel() {
		if (queryManageSetPanel == null) {
			queryManageSetPanel = new ESplitPane();
			queryManageSetPanel.setLeftComponent(getCatalogSchemaTableListPanel());
			queryManageSetPanel.setRightComponent(getQueryManageResultSetPanel());
		}
		return queryManageSetPanel;
	}

	/**
	 * e[uXgpl擾܂B<br>
	 * @return e[uXgpl
	 */
	public CatalogSchemaTableListPanel getCatalogSchemaTableListPanel() {
		if (catalogSchemaTableListPanel == null) {
			catalogSchemaTableListPanel = new CatalogSchemaTableListPanel();
			catalogSchemaTableListPanel.getTableTreeScrollPane().setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
			catalogSchemaTableListPanel.getTableTree().addMouseListener(new MouseAdapter() {
				public void mouseClicked(MouseEvent e) {
					QueryManageActionContainer.instance().tableClickAction(e);
				}
			});
		}
		return catalogSchemaTableListPanel;
	}

	/**
	 * NGsZbgpl擾܂B<br>
	 * @return NGsZbgpl
	 */
	public ESplitPane getQueryExecuteSetPanel() {
		if (queryExecuteSetPanel == null) {
			queryExecuteSetPanel = new ESplitPane();
			queryExecuteSetPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
			queryExecuteSetPanel.setOneTouchExpandable(true);
			queryExecuteSetPanel.setOrientation(JSplitPane.VERTICAL_SPLIT);
			queryExecuteSetPanel.setDividerLocation(80);
			queryExecuteSetPanel.setTopComponent(QueryManageTextPane.instance());
			queryExecuteSetPanel.setBottomComponent(QueryManageResultTablePane.instance());
		}
		return queryExecuteSetPanel;
	}

	/**
	 * NGZbgpl擾܂B<br>
	 * @return NGZbgpl
	 */
	public ESplitPane getQueryManageResultSetPanel() {
		if (queryManageResultSetPanel == null) {
			queryManageResultSetPanel = new ESplitPane();
			queryManageResultSetPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
			queryManageResultSetPanel.setOrientation(JSplitPane.VERTICAL_SPLIT);
			queryManageResultSetPanel.setDividerLocation(-1);
			queryManageResultSetPanel.setTopComponent(getQueryExecuteSetPanel());
			queryManageResultSetPanel.setBottomComponent(QueryManageErrorListPane.instance());
		}
		return queryManageResultSetPanel;
	}
}
