package org.phosphoresce.dbbrowser.gui.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.NumberFormat;

import javax.swing.border.MatteBorder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EMessageDialog;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.EProgressBar;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * t[Xe[^Xo[pl<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/23	Kitagawa		VK쐬
 *-->
 */
public final class FrameStatusBarPanel extends EPanel implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** ZtCX^X */
	private static FrameStatusBarPanel instance = null;

	/** R|[lgtbVXbh */
	private Thread refreshThread = null;

	/** Xe[^Xo[Xy[T[ */
	private ELabel statusBarSpacer = null;

	/** [io[tH[}bg */
	private NumberFormat memoryNumberFormat = null;

	/** o[x */
	private ELabel memoryBarLabel = null;

	/** [o[ */
	private EProgressBar memoryBar = null;

	/** JDBCAhX */
	private ELabel jdbcUrlLabel = null;

	/**
	 * RXgN^<br>
	 */
	private FrameStatusBarPanel() {
		super();
		initialize();

		this.refreshThread = new Thread(new Runnable() {
			public void run() {
				try {
					while (true) {
						refresh();
						Thread.sleep(500);
					}
				} catch (Throwable throwable) {
					String errorMessage = "failed to refresh status bar.<br>stoped refresh thread.";
					log.error(errorMessage, throwable);
					EMessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
				}
			}
		});
		this.refreshThread.start();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static FrameStatusBarPanel instance() {
		if (instance == null) {
			instance = new FrameStatusBarPanel();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		if (DatabaseBrowserSession.instance().getConfig() != null) {
			double totalMemory = (double) Runtime.getRuntime().totalMemory() / 1024.0D / 1024.0D;
			double maxMemory = (double) Runtime.getRuntime().maxMemory() / 1024.0D / 1024.0D;
			double freeMemory = (double) Runtime.getRuntime().freeMemory() / 1024.0D / 1024.0D;
			double usedMemory = totalMemory - freeMemory;
			getMemoryBar().setMinimum(0);
			getMemoryBar().setMaximum((int) totalMemory);
			getMemoryBar().setValue((int) usedMemory);
			getMemoryBar().setString(getMemoryNumberFormat().format(freeMemory) + " MB");

			getJdbcUrlLabel().setText(DatabaseBrowserSession.instance().getConfig().getJdbcUrl());
		}
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
		gridBagConstraints11.fill = GridBagConstraints.BOTH;
		gridBagConstraints11.insets = new Insets(2, 2, 2, 2);
		gridBagConstraints11.weightx = 0.0D;
		gridBagConstraints11.weighty = 1.0D;
		gridBagConstraints11.gridx = 0;
		gridBagConstraints11.gridy = 0;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.fill = GridBagConstraints.BOTH;
		gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
		gridBagConstraints2.weightx = 0.0D;
		gridBagConstraints2.weighty = 1.0D;
		gridBagConstraints2.gridx = 3;
		gridBagConstraints2.gridy = 0;
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
		gridBagConstraints1.weightx = 0.0D;
		gridBagConstraints1.weighty = 1.0D;
		gridBagConstraints1.gridx = 2;
		gridBagConstraints1.gridy = 0;
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.fill = GridBagConstraints.BOTH;
		gridBagConstraints.insets = new Insets(2, 2, 2, 2);
		gridBagConstraints.weightx = 1.0D;
		gridBagConstraints.weighty = 1.0D;
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(600, 20));
		this.setPreferredSize(new Dimension(600, 20));
		this.setMinimumSize(new Dimension(600, 20));
		this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
		this.add(getStatusBarSpacer(), gridBagConstraints);
		this.add(getMemoryBarLabel(), gridBagConstraints1);
		this.add(getMemoryBar(), gridBagConstraints2);
		this.add(getJdbcUrlLabel(), gridBagConstraints11);
		this.setBorder(new MatteBorder(1, 0, 0, 0, Color.GRAY));
	}

	/**
	 * Xe[^Xo[Xy[T[擾܂B<br>
	 * @return Xe[^Xo[Xy[T[
	 */
	private ELabel getStatusBarSpacer() {
		if (statusBarSpacer == null) {
			statusBarSpacer = new ELabel();
		}
		return statusBarSpacer;
	}

	/**
	 * [io[tH[}bg擾܂B<br>
	 * @return [io[tH[}bg
	 */
	private NumberFormat getMemoryNumberFormat() {
		if (memoryNumberFormat == null) {
			memoryNumberFormat = new DecimalFormat("0.00");
		}
		return memoryNumberFormat;
	}

	/**
	 * o[x擾܂B<br>
	 * @return o[x
	 */
	private ELabel getMemoryBarLabel() {
		if (memoryBarLabel == null) {
			memoryBarLabel = new ELabel();
			memoryBarLabel.setText("Free Memory ");
		}
		return memoryBarLabel;
	}

	/**
	 * [o[擾܂B<br>
	 * @return [o[
	 */
	private EProgressBar getMemoryBar() {
		if (memoryBar == null) {
			memoryBar = new EProgressBar();
			memoryBar.setPreferredSize(new Dimension(80, 12));
			memoryBar.setMaximumSize(new Dimension(80, 12));
			memoryBar.setMinimumSize(new Dimension(80, 12));
			memoryBar.setStringPainted(true);
			memoryBar.setFont(new Font("Tahoma", Font.PLAIN, 10));
			memoryBar.setString("");
		}
		return memoryBar;
	}

	/**
	 * JDBCAhX擾܂B<br>
	 * @return JDBCAhXx
	 */
	private ELabel getJdbcUrlLabel() {
		if (jdbcUrlLabel == null) {
			jdbcUrlLabel = new ELabel();
		}
		return jdbcUrlLabel;
	}
}
