package org.phosphoresce.dbbrowser;

import java.awt.Frame;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.phosphoresce.commons.eswing.EMessageDialog;
import org.phosphoresce.commons.eswing.core.ESwingConfig;
import org.phosphoresce.commons.eswing.core.ESwingConfigManager;
import org.phosphoresce.commons.logging.appender.TextPaneAppender;
import org.phosphoresce.commons.logging.config.LoggingColorSet;
import org.phosphoresce.dbbrowser.config.DatabaseBrowserConfig;
import org.phosphoresce.dbbrowser.config.DatabaseBrowserWindowComponentQueryManageConfig;
import org.phosphoresce.dbbrowser.gui.panel.querymanage.QueryManageEditorPane;
import org.phosphoresce.dbbrowser.gui.window.main.DatabaseBrowserPane;
import org.phosphoresce.dbbrowser.resource.definition.dbdriver.DatabaseBrowserJDBCSample;

/**
 * DatabaseBrowserAvP[VCNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/16	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowser {

	/**
	 * RXgN^<br>
	 */
	private DatabaseBrowser() {
		super();
	}

	/**
	 * C\bh<br>
	 * @param args R}hC
	 */
	public static void main(String[] args) {
		try {
			initialize();

			Log log = LogFactory.getLog(DatabaseBrowser.class);
			log.info("initialized application.");

			startup();
			log.info("successed to startup application.");
		} catch (Throwable throwable) {
			String errorMessage = "raised critical application exception.";
			EMessageDialog.showError((Frame) null, errorMessage, throwable);
			exit();
		}
	}

	/**
	 * ꊇōs܂B<br>
	 * @throws Throwable \ʗOꍇɃX[܂
	 */
	public static void initialize() throws Throwable {
		initializeSwing();
		initializeLogger();
		initializeConfigs();
	}

	/**
	 * Swing֘Ȁs܂B<br>
	 * @throws Throwable \ʗOꍇɃX[܂
	 */
	private static void initializeSwing() throws Throwable {
		ESwingConfigManager.configure();
		ESwingConfig.initializeMessageDialogConfig();
	}

	/**
	 * K[֘Ȁs܂B<br>
	 * @throws Throwable \ʗOꍇɃX[܂
	 */
	private static void initializeLogger() throws Throwable {
		DOMConfigurator.configure(DatabaseBrowser.class.getResource(DatabaseBrowserConstants.LOG4J_CONFIG_FILE));
		TextPaneAppender appender = TextPaneAppender.getAppender("textpane");
		if (appender != null) {
			appender.setColorSet(new LoggingColorSet());
		}
	}

	/**
	 * AvP[V̏s܂B<br>
	 * @throws Throwable \ʗOꍇɃX[܂
	 */
	private static void initializeConfigs() throws Throwable {
		DatabaseBrowserConfig.instance().load();
		DatabaseBrowserJDBCSample.instance();
	}

	/**
	 * DatabaseBrowserN܂B<br>
	 * @throws Throwable \ʗOꍇɃX[܂
	 */
	private static void startup() throws Throwable {
		DatabaseBrowserConfig config = DatabaseBrowserConfig.instance();
		DatabaseBrowserSession session = DatabaseBrowserSession.instance();
		session.initializeConfig();

		session.getBrowserFrame().setBounds(config.getWindowConfig().getBoundsConfig().getBounds());
		session.getBrowserFrame().setExtendedState(config.getWindowConfig().getBoundsConfig().getExtendsState());

		DatabaseBrowserPane.instance().setDividerLocation(config.getWindowConfig().getComponentConfig().getMessagePaneLocation());
		DatabaseBrowserPane.instance().setLastDividerLocation(config.getWindowConfig().getComponentConfig().getMessagePaneLocation());

		QueryManageEditorPane queryManageEditorPane = QueryManageEditorPane.instance();
		DatabaseBrowserWindowComponentQueryManageConfig queryManageConfig = config.getWindowConfig().getComponentConfig().getQueryManageConfig();
		queryManageEditorPane.getQueryManageSetPanel().setDividerLocation(queryManageConfig.getTableTreePaneDivideLocation());
		queryManageEditorPane.getQueryManageSetPanel().setLastDividerLocation(queryManageConfig.getTableTreePaneDivideLocation());
		queryManageEditorPane.getQueryExecuteSetPanel().setDividerLocation(queryManageConfig.getQueryAreaDivideLocation());
		queryManageEditorPane.getQueryExecuteSetPanel().setLastDividerLocation(queryManageConfig.getQueryAreaDivideLocation());
		queryManageEditorPane.getQueryManageResultSetPanel().setDividerLocation(queryManageConfig.getResultAreaDivideLocation());
		queryManageEditorPane.getQueryManageResultSetPanel().setLastDividerLocation(queryManageConfig.getResultAreaDivideLocation());

		session.getBrowserFrame().setVisible(true);
	}

	/**
	 * DatabaseBrowserI܂B<br>
	 */
	public static void exit() {
		try {
			DatabaseBrowserConfig config = DatabaseBrowserConfig.instance();
			DatabaseBrowserSession session = DatabaseBrowserSession.instance();

			if (session.isInstancedBrowserFrame()) {
				config.getWindowConfig().getBoundsConfig().setBounds(session.getBrowserFrame().getRealBounds());
				config.getWindowConfig().getBoundsConfig().setExtendsState(session.getBrowserFrame().getExtendedState());
				config.getWindowConfig().getComponentConfig().setMessagePaneLocation(DatabaseBrowserPane.instance().getLastDividerLocation());

				QueryManageEditorPane queryManageEditorPane = QueryManageEditorPane.instance();
				DatabaseBrowserWindowComponentQueryManageConfig queryManageConfig = config.getWindowConfig().getComponentConfig().getQueryManageConfig();
				queryManageConfig.setTableTreePaneDivideLocation(queryManageEditorPane.getQueryManageSetPanel().getDividerLocation());
				queryManageConfig.setQueryAreaDivideLocation(queryManageEditorPane.getQueryExecuteSetPanel().getDividerLocation());
				queryManageConfig.setResultAreaDivideLocation(queryManageEditorPane.getQueryManageResultSetPanel().getDividerLocation());
			}

			config.save();
		} catch (Throwable e) {
			e.printStackTrace();
		} finally {
			System.exit(0);
		}
	}
}
