/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.window.main;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EMenu;
import org.phosphoresce.commons.eswing.EMenuBar;
import org.phosphoresce.commons.eswing.EMenuItem;
import org.phosphoresce.commons.eswing.EMessageDialog;
import org.phosphoresce.dbbrowser.DatabaseBrowser;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.common.window.ConnectionConfigureFrame;
import org.phosphoresce.dbbrowser.gui.window.about.AboutDialog;
import org.phosphoresce.dbbrowser.gui.window.main.DatabaseBrowserFrame;
import org.phosphoresce.dbbrowser.gui.window.main.DatabaseBrowserTabbedPane;
import org.phosphoresce.dbbrowser.resource.image.DatabaseBrowserImages;

public final class DatabaseBrowserMenuBar
extends EMenuBar
implements RefreshableComponent {
    private Log log = LogFactory.getLog(this.getClass());
    private static DatabaseBrowserMenuBar instance = null;
    private EMenu browserMenuFile = null;
    private EMenu browserMenuView = null;
    private EMenu browserMenuHelp = null;
    private EMenuItem browserMenuItemAbout = null;
    private EMenuItem browserMenuItemNewConnection = null;
    private EMenuItem browserMenuItemExit = null;
    private EMenuItem browserMenuItemClientInformationView = null;
    private EMenuItem browserMenuItemDatabaseInformationView = null;
    private EMenuItem browserMenuItemQueryManagerView = null;

    private DatabaseBrowserMenuBar() {
        this.initialize();
    }

    public static DatabaseBrowserMenuBar instance() {
        if (instance == null) {
            instance = new DatabaseBrowserMenuBar();
        }
        return instance;
    }

    public void refresh() throws Throwable {
    }

    private void initialize() {
        this.add((JMenu)this.getBrowserMenuFile());
        this.add((JMenu)this.getBrowserMenuView());
        this.add((JMenu)this.getBrowserMenuHelp());
    }

    private EMenu getBrowserMenuFile() {
        if (this.browserMenuFile == null) {
            this.browserMenuFile = new EMenu("File");
            this.browserMenuFile.setMnemonic('F');
            this.browserMenuFile.add((JMenuItem)this.getBrowserMenuItemNewConnection());
            this.browserMenuFile.addSeparator();
            this.browserMenuFile.add((JMenuItem)this.getBrowserMenuItemExit());
        }
        return this.browserMenuFile;
    }

    private EMenu getBrowserMenuView() {
        if (this.browserMenuView == null) {
            this.browserMenuView = new EMenu("View");
            this.browserMenuView.setMnemonic('V');
            this.browserMenuView.add((JMenuItem)this.getBrowserMenuItemClientInformationView());
            this.browserMenuView.add((JMenuItem)this.getBrowserMenuItemDatabaseInformationView());
            this.browserMenuView.add((JMenuItem)this.getBrowserMenuItemQueryManagerView());
        }
        return this.browserMenuView;
    }

    private EMenu getBrowserMenuHelp() {
        if (this.browserMenuHelp == null) {
            this.browserMenuHelp = new EMenu("Help");
            this.browserMenuHelp.setMnemonic('H');
            this.browserMenuHelp.add((JMenuItem)this.getBrowserMenuItemAbout());
        }
        return this.browserMenuHelp;
    }

    private EMenuItem getBrowserMenuItemAbout() {
        if (this.browserMenuItemAbout == null) {
            this.browserMenuItemAbout = new EMenuItem("About...");
            this.browserMenuItemAbout.setMnemonic('A');
            this.browserMenuItemAbout.setIconTextGap(5);
            this.browserMenuItemAbout.setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_APP_ICON_20));
            this.browserMenuItemAbout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        AboutDialog.showAboutDialog();
                    }
                    catch (Throwable throwable) {
                        String errorMessage = "failed to show about dialog.";
                        DatabaseBrowserMenuBar.this.log.error((Object)errorMessage, throwable);
                        EMessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), (String)errorMessage, (Throwable)throwable);
                    }
                }
            });
        }
        return this.browserMenuItemAbout;
    }

    private EMenuItem getBrowserMenuItemNewConnection() {
        if (this.browserMenuItemNewConnection == null) {
            this.browserMenuItemNewConnection = new EMenuItem("New Connection...");
            this.browserMenuItemNewConnection.setIconTextGap(5);
            this.browserMenuItemNewConnection.setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_SPACER_20));
            this.browserMenuItemNewConnection.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        new ConnectionConfigureFrame((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), DatabaseBrowserSession.instance()).setVisible(true);
                        DatabaseBrowserFrame.instance().refresh();
                    }
                    catch (Throwable throwable) {
                        String errorMessage = "failed to connect new database instance.";
                        DatabaseBrowserMenuBar.this.log.error((Object)errorMessage, throwable);
                        EMessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), (String)errorMessage, (Throwable)throwable);
                    }
                }
            });
        }
        return this.browserMenuItemNewConnection;
    }

    private EMenuItem getBrowserMenuItemExit() {
        if (this.browserMenuItemExit == null) {
            this.browserMenuItemExit = new EMenuItem("Exit");
            this.browserMenuItemExit.setMnemonic('X');
            this.browserMenuItemExit.setIconTextGap(5);
            this.browserMenuItemExit.setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_SPACER_20));
            this.browserMenuItemExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DatabaseBrowser.exit();
                }
            });
        }
        return this.browserMenuItemExit;
    }

    private EMenuItem getBrowserMenuItemClientInformationView() {
        if (this.browserMenuItemClientInformationView == null) {
            this.browserMenuItemClientInformationView = new EMenuItem("ClientInformationView");
            this.browserMenuItemClientInformationView.setMnemonic('C');
            this.browserMenuItemClientInformationView.setIconTextGap(5);
            this.browserMenuItemClientInformationView.setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_CLIENTPC_20));
            this.browserMenuItemClientInformationView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DatabaseBrowserTabbedPane.instance().setSelectedIndex(0);
                }
            });
        }
        return this.browserMenuItemClientInformationView;
    }

    private EMenuItem getBrowserMenuItemDatabaseInformationView() {
        if (this.browserMenuItemDatabaseInformationView == null) {
            this.browserMenuItemDatabaseInformationView = new EMenuItem("DatabaseInformationView");
            this.browserMenuItemDatabaseInformationView.setMnemonic('D');
            this.browserMenuItemDatabaseInformationView.setIconTextGap(5);
            this.browserMenuItemDatabaseInformationView.setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_DATABASE_20));
            this.browserMenuItemDatabaseInformationView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DatabaseBrowserTabbedPane.instance().setSelectedIndex(1);
                }
            });
        }
        return this.browserMenuItemDatabaseInformationView;
    }

    private EMenuItem getBrowserMenuItemQueryManagerView() {
        if (this.browserMenuItemQueryManagerView == null) {
            this.browserMenuItemQueryManagerView = new EMenuItem("QueryManagerView");
            this.browserMenuItemQueryManagerView.setMnemonic('Q');
            this.browserMenuItemQueryManagerView.setIconTextGap(5);
            this.browserMenuItemQueryManagerView.setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_QUERY_20));
            this.browserMenuItemQueryManagerView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DatabaseBrowserTabbedPane.instance().setSelectedIndex(2);
                }
            });
        }
        return this.browserMenuItemQueryManagerView;
    }
}

