/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.panel.querymanage;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.csv.CSVRecord;
import org.phosphoresce.commons.csv.CSVToken;
import org.phosphoresce.commons.database.DatabaseInformation;
import org.phosphoresce.commons.database.accessor.RecordTableModelAccessor;
import org.phosphoresce.commons.database.accessor.ResultColumn;
import org.phosphoresce.commons.database.accessor.ResultColumnDefinition;
import org.phosphoresce.commons.database.container.DatabaseTable;
import org.phosphoresce.commons.database.core.DatabaseQueryManager;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.eswing.EMessageDialog;
import org.phosphoresce.commons.eswing.ETable;
import org.phosphoresce.commons.eswing.ETextArea;
import org.phosphoresce.commons.eswing.ETree;
import org.phosphoresce.commons.eswing.sample.TableSorter;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.common.window.ProcessAction;
import org.phosphoresce.dbbrowser.gui.common.window.ProcessDialog;
import org.phosphoresce.dbbrowser.gui.panel.querymanage.QueryManageEditorPane;
import org.phosphoresce.dbbrowser.gui.panel.querymanage.QueryManageErrorListPane;
import org.phosphoresce.dbbrowser.gui.panel.querymanage.QueryManageResultTablePane;
import org.phosphoresce.dbbrowser.gui.panel.querymanage.QueryManageTextPane;

final class QueryManageActionContainer {
    private Log log = LogFactory.getLog(this.getClass());
    private static QueryManageActionContainer instance = null;

    private QueryManageActionContainer() {
    }

    public static QueryManageActionContainer instance() {
        if (instance == null) {
            instance = new QueryManageActionContainer();
        }
        return instance;
    }

    private RecordTableModelAccessor getTableModelAccessor() {
        ETable table = QueryManageResultTablePane.instance().getResultTable();
        TableModel model = table.getModel();
        if (model == null) {
            return null;
        }
        if (model instanceof RecordTableModelAccessor) {
            return (RecordTableModelAccessor)model;
        }
        if (model instanceof TableSorter) {
            TableSorter sorter = (TableSorter)model;
            return (RecordTableModelAccessor)sorter.getTableModel();
        }
        return null;
    }

    public void tableClickAction(MouseEvent e) {
        try {
            if (e.getClickCount() >= 2) {
                DatabaseInformation information = new DatabaseInformation(DatabaseBrowserSession.instance().getCommonDatabaseSession());
                ETree tree = QueryManageEditorPane.instance().getCatalogSchemaTableListPanel().getTableTree();
                ETextArea textArea = QueryManageTextPane.instance().getQueryText();
                String separator = information.getCatalogSeparator();
                int row = tree.getClosestRowForLocation(e.getX(), e.getY());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getPathForRow(row).getLastPathComponent();
                if (node.getUserObject() != null && node.getUserObject() instanceof DatabaseTable) {
                    DatabaseTable table = (DatabaseTable)node.getUserObject();
                    if (table.getTableHolder() != null) {
                        textArea.setText("select * from " + table.getTableHolder().getName() + separator + table.getName());
                    } else {
                        textArea.setText("select * from " + table.getName());
                    }
                    this.execute();
                    this.log.trace((Object)"execute select query of tree table element.");
                }
            }
        }
        catch (Throwable throwable) {
            String errorMessage = "failed to insert row.";
            this.log.error((Object)errorMessage, throwable);
            EMessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), (String)errorMessage, (Throwable)throwable);
        }
    }

    public void inertrow() {
        try {
            ETable table = QueryManageResultTablePane.instance().getResultTable();
            QueryManageErrorListPane errorPanel = QueryManageErrorListPane.instance();
            RecordTableModelAccessor accessor = this.getTableModelAccessor();
            if (accessor != null) {
                accessor.insertRow();
                this.log.trace((Object)"inserted new row.");
            }
        }
        catch (Throwable throwable) {
            String errorMessage = "failed to insert row.";
            this.log.error((Object)errorMessage, throwable);
            EMessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), (String)errorMessage, (Throwable)throwable);
        }
    }

    public void deleterow() {
        this.log.trace((Object)"delete selected row.");
        try {
            ETable table = QueryManageResultTablePane.instance().getResultTable();
            QueryManageErrorListPane errorPanel = QueryManageErrorListPane.instance();
            RecordTableModelAccessor accessor = this.getTableModelAccessor();
            if (accessor != null) {
                int[] rows = table.getSelectedRows();
                for (int i = 0; i <= rows.length - 1; ++i) {
                    accessor.deleteRow(rows[i]);
                }
                this.log.trace((Object)("deleted " + rows.length + " rows."));
            }
        }
        catch (Throwable throwable) {
            String errorMessage = "failed to delete row.";
            this.log.error((Object)errorMessage, throwable);
            EMessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), (String)errorMessage, (Throwable)throwable);
        }
    }

    public void execute() {
        this.log.trace((Object)"execute query.");
        ProcessDialog.execute((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), new ProcessAction(){

            public void execute() {
                try {
                    DatabaseSession session = DatabaseBrowserSession.instance().getDatabaseSession("QueryManageDatabaseSession");
                    ETable table = QueryManageResultTablePane.instance().getResultTable();
                    QueryManageErrorListPane errorPanel = QueryManageErrorListPane.instance();
                    errorPanel.clearError();
                    session.rollback();
                    session.close();
                    table.setModel(new DefaultTableModel());
                    DatabaseQueryManager manager = new DatabaseQueryManager(session);
                    manager.setQuery(QueryManageTextPane.instance().getQueryText().getText());
                    manager.execute();
                    if (manager.hasError()) {
                        errorPanel.addError(manager.getError());
                    } else if (!manager.isSelectQuery()) {
                        table.setModel(new DefaultTableModel(new String[][]{{String.valueOf(manager.getUpdateCount())}}, new String[]{"update_count"}));
                        table.setEnabled(false);
                        table.setAutoResizeMode(4);
                        session.commit();
                    } else {
                        RecordTableModelAccessor accessor = new RecordTableModelAccessor(manager.getResultSet());
                        TableSorter sorter = new TableSorter((TableModel)accessor, table.getTableHeader());
                        table.setModel((TableModel)sorter);
                        table.setEnabled(true);
                        table.setAutoResizeMode(0);
                        session.commit();
                        for (int i = 0; i <= accessor.getResultRowDefinition().getColumnCount() - 1; ++i) {
                            TableColumnModel columnModel = table.getColumnModel();
                            String headerString = (String)table.getTableHeader().getColumnModel().getColumn(i).getHeaderValue();
                            int size = accessor.getResultColumnDefinition(i).getDisplaySize();
                            size = size < headerString.length() ? headerString.length() : size;
                            size = size > 25 ? 25 : size;
                            columnModel.getColumn(i).setPreferredWidth(size * 6);
                        }
                    }
                }
                catch (Throwable throwable) {
                    String errorMessage = "failed to execute query.";
                    QueryManageActionContainer.this.log.error((Object)errorMessage, throwable);
                    EMessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), (String)errorMessage, (Throwable)throwable);
                }
            }
        }, false);
    }

    public void commit() {
        this.log.trace((Object)"session commit.");
        try {
            DatabaseSession session = DatabaseBrowserSession.instance().getDatabaseSession("QueryManageDatabaseSession");
            ETable table = QueryManageResultTablePane.instance().getResultTable();
            QueryManageErrorListPane errorPanel = QueryManageErrorListPane.instance();
            QueryManageErrorListPane.instance().clearError();
            RecordTableModelAccessor accessor = this.getTableModelAccessor();
            if (accessor != null) {
                accessor.updateResult();
                session.commit();
                accessor.refreshResult();
                errorPanel.clearError();
                errorPanel.addError(accessor.getErrors());
                this.log.trace((Object)"commited session transaction.");
            }
        }
        catch (Throwable throwable) {
            String errorMessage = "failed to commit.";
            this.log.error((Object)errorMessage, throwable);
            EMessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), (String)errorMessage, (Throwable)throwable);
        }
    }

    public void rollback() {
        this.log.trace((Object)"session rollback.");
        try {
            DatabaseSession session = DatabaseBrowserSession.instance().getDatabaseSession("QueryManageDatabaseSession");
            ETable table = QueryManageResultTablePane.instance().getResultTable();
            QueryManageErrorListPane errorPanel = QueryManageErrorListPane.instance();
            QueryManageErrorListPane.instance().clearError();
            RecordTableModelAccessor accessor = this.getTableModelAccessor();
            if (accessor != null) {
                session.rollback();
                accessor.refreshResult();
                errorPanel.clearError();
                errorPanel.addError(accessor.getErrors());
                this.log.trace((Object)"rollbacked session transaction.");
            }
        }
        catch (Throwable throwable) {
            String errorMessage = "failed to rollback.";
            this.log.error((Object)errorMessage, throwable);
            EMessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), (String)errorMessage, (Throwable)throwable);
        }
    }

    public void save() {
        this.log.trace((Object)"save result.");
        try {
            DatabaseSession session = DatabaseBrowserSession.instance().getDatabaseSession("QueryManageDatabaseSession");
            ETable table = QueryManageResultTablePane.instance().getResultTable();
            QueryManageErrorListPane errorPanel = QueryManageErrorListPane.instance();
            RecordTableModelAccessor accessor = this.getTableModelAccessor();
            if (accessor != null) {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogType(1);
                chooser.setDialogTitle("Save to CSV File");
                chooser.setMultiSelectionEnabled(false);
                chooser.addChoosableFileFilter(new FileFilter(){

                    public String getDescription() {
                        return "CSV\u30d5\u30a1\u30a4\u30eb(*.csv)";
                    }

                    public boolean accept(File file) {
                        if (file == null) {
                            return false;
                        }
                        if (file.isDirectory()) {
                            return true;
                        }
                        return file.getAbsolutePath().endsWith(".csv");
                    }
                });
                boolean loopflag = true;
                while (loopflag) {
                    int chooserReturn = chooser.showSaveDialog((Component)((Object)DatabaseBrowserSession.instance().getBrowserFrame()));
                    File file = chooser.getSelectedFile();
                    if (chooserReturn == 0) {
                        boolean save = false;
                        if (file.exists()) {
                            String filename = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
                            int returnvalue = EMessageDialog.showQuestion((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), (String)(filename + " is already exist.<br>over write this file ?"));
                            if (returnvalue == 2) {
                                save = true;
                            }
                        } else {
                            save = true;
                        }
                        if (!save) continue;
                        this.log.trace((Object)("save to " + file + "."));
                        loopflag = false;
                        this.save(file);
                        continue;
                    }
                    loopflag = false;
                }
            }
        }
        catch (Throwable throwable) {
            String errorMessage = "failed to save result.";
            this.log.error((Object)errorMessage, throwable);
            EMessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), (String)errorMessage, (Throwable)throwable);
        }
    }

    private void save(final File file) throws Throwable {
        ProcessDialog.execute((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), new ProcessAction(){

            public void execute() throws Throwable {
                int i;
                RecordTableModelAccessor accessor = QueryManageActionContainer.this.getTableModelAccessor();
                if (file == null || accessor == null) {
                    return;
                }
                PrintWriter writer = new PrintWriter(new FileOutputStream(file));
                CSVRecord definitionRecord = new CSVRecord();
                for (i = 0; i <= accessor.getColumnCount() - 1; ++i) {
                    ResultColumnDefinition columnDefinition = accessor.getResultColumnDefinition(i);
                    CSVToken token = new CSVToken(columnDefinition.getName());
                    definitionRecord.add(token);
                }
                writer.println(definitionRecord.getRecordValue());
                writer.flush();
                for (i = 0; i <= accessor.getRowCount() - 1; ++i) {
                    CSVRecord record = new CSVRecord();
                    for (int j = 0; j <= accessor.getColumnCount() - 1; ++j) {
                        ResultColumn column = accessor.getResultColumn(i, j);
                        Object object = column.getValue();
                        CSVToken token = new CSVToken(object == null ? "" : object.toString());
                        record.add(token);
                    }
                    writer.println(record.getRecordValue());
                    writer.flush();
                }
                writer.close();
            }
        }, false);
    }
}

