/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.commons.database.exception.DatabaseSessionException;

public class DatabaseSession {
    private Log log = LogFactory.getLog(this.getClass());
    private DatabaseConfig config;
    private Connection connection;

    public DatabaseSession(DatabaseConfig config) throws DatabaseSessionException {
        if (config == null) {
            throw new DatabaseSessionException("null 'config' argument.");
        }
        this.config = config;
        this.connection = this.createConnection();
        this.log.trace((Object)("new database session created. [" + config.getJdbcUrl() + "]"));
    }

    private DatabaseSession() throws DatabaseSessionException {
        this(null);
    }

    private Connection createConnection() throws DatabaseSessionException {
        try {
            Class.forName(this.config.getJdbcDriver());
            Connection connection = DriverManager.getConnection(this.config.getJdbcUrl(), this.config.getJdbcUser(), this.config.getJdbcPassword());
            connection.setAutoCommit(this.config.isAutoCommit());
            this.log.trace((Object)"new database connection created.");
            return connection;
        }
        catch (Throwable throwable) {
            throw new DatabaseSessionException("failed to create new database connection.", throwable);
        }
    }

    public Connection getConnection() throws DatabaseSessionException {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = this.createConnection();
            }
            return this.connection;
        }
        catch (SQLException e) {
            throw new DatabaseSessionException("failed to get database connection", e);
        }
    }

    public void close() throws DatabaseSessionException {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
            this.log.trace((Object)"database connection closed.");
        }
        catch (SQLException e) {
            throw new DatabaseSessionException("failed to close database connection.", e);
        }
    }

    public void commit() throws DatabaseSessionException {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.commit();
            }
            this.log.trace((Object)"database connection commited.");
        }
        catch (SQLException e) {
            throw new DatabaseSessionException("failed to commit database connection.", e);
        }
    }

    public void rollback() throws DatabaseSessionException {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.rollback();
            }
            this.log.trace((Object)"database connection rollbacked.");
        }
        catch (SQLException e) {
            throw new DatabaseSessionException("failed to rollback database connection.", e);
        }
    }
}

