/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.phosphoresce.commons.database.accessor.ResultAccessorAbstract;
import org.phosphoresce.commons.database.accessor.ResultAccessorListener;
import org.phosphoresce.commons.database.accessor.ResultAccessorState;
import org.phosphoresce.commons.database.accessor.ResultColumnDefinition;
import org.phosphoresce.commons.database.accessor.ResultRow;
import org.phosphoresce.commons.database.accessor.util.AccessorColumnUtil;
import org.phosphoresce.commons.database.core.DatabaseError;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

public final class ResultColumn
extends ResultAccessorAbstract {
    private ResultColumnDefinition definition;
    private ResultRow row;
    private int index = -1;
    private Object value;

    ResultColumn(ResultSet resultSet, ResultAccessorState state, ResultAccessorListener listener, ResultRow row, ResultColumnDefinition definition, int index) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        super(resultSet, state, listener);
        this.definition = definition;
        this.row = row;
        this.index = index;
        this.refreshResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        this.definition.refreshResult(force);
        int currentRow = this.getResultSetRowIndex();
        try {
            block8: {
                try {
                    int columnCount = this.resultSet.getMetaData().getColumnCount();
                    this.moveCurser(this.getRowIndex() + 1);
                    if (this.state == ResultAccessorState.INSERT_ERROR) break block8;
                    if (this.state == ResultAccessorState.UPDATE_ERROR) {
                        if (force) {
                            this.value = this.resultSet.getObject(this.index + 1);
                            this.state = ResultAccessorState.STATIC;
                        }
                        break block8;
                    }
                    if (this.state == ResultAccessorState.REMOVED) break block8;
                    if (this.state == ResultAccessorState.DELETE) {
                        this.value = this.resultSet.getObject(this.index + 1);
                        this.state = ResultAccessorState.STATIC;
                        break block8;
                    }
                    if (this.state == ResultAccessorState.INSERT_DELETE || this.state == ResultAccessorState.INSERT) break block8;
                    if (this.state == ResultAccessorState.UPDATE) {
                        this.resultSet.absolute(this.row.getIndex() + 1);
                        this.value = this.resultSet.getObject(this.index + 1);
                        this.state = ResultAccessorState.STATIC;
                        break block8;
                    }
                    if (this.state != ResultAccessorState.STATIC) break block8;
                    this.resultSet.absolute(this.row.getIndex() + 1);
                    this.value = this.resultSet.getObject(this.index + 1);
                    this.state = ResultAccessorState.STATIC;
                }
                catch (SQLException e) {
                    this.state = this.state == ResultAccessorState.INSERT ? ResultAccessorState.INSERT_ERROR : (this.state == ResultAccessorState.INSERT_ERROR ? ResultAccessorState.INSERT_ERROR : ResultAccessorState.UPDATE_ERROR);
                    this.error = new DatabaseError(this.row.getIndex(), this.index, e);
                    Object var5_6 = null;
                    this.moveCurser(currentRow);
                    if (!this.validateStateListener()) return;
                    this.listener.columnChanged(this.row.getIndex(), this.index);
                    return;
                }
            }
            Object var5_5 = null;
            this.moveCurser(currentRow);
            if (!this.validateStateListener()) return;
            this.listener.columnChanged(this.row.getIndex(), this.index);
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.moveCurser(currentRow);
            if (!this.validateStateListener()) throw throwable;
            this.listener.columnChanged(this.row.getIndex(), this.index);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        int currentRow = this.getResultSetRowIndex();
        try {
            block9: {
                try {
                    this.error = null;
                    int columnCount = this.resultSet.getMetaData().getColumnCount();
                    if (this.state == ResultAccessorState.INSERT_ERROR) {
                        this.resultSet.updateObject(this.index + 1, AccessorColumnUtil.renderColumnObject(this.definition, this.value));
                        this.state = ResultAccessorState.STATIC;
                        break block9;
                    }
                    if (this.state == ResultAccessorState.UPDATE_ERROR) {
                        this.resultSet.absolute(this.row.getIndex() + 1);
                        this.resultSet.updateObject(this.index + 1, AccessorColumnUtil.renderColumnObject(this.definition, this.value));
                        this.resultSet.updateRow();
                        this.state = ResultAccessorState.STATIC;
                        break block9;
                    }
                    if (this.state == ResultAccessorState.REMOVED) break block9;
                    if (this.state == ResultAccessorState.DELETE) {
                        this.state = ResultAccessorState.REMOVED;
                        break block9;
                    }
                    if (this.state == ResultAccessorState.INSERT_DELETE) break block9;
                    if (this.state == ResultAccessorState.INSERT) {
                        this.resultSet.updateObject(this.index + 1, AccessorColumnUtil.renderColumnObject(this.definition, this.value));
                        this.state = ResultAccessorState.STATIC;
                        break block9;
                    }
                    if (this.state == ResultAccessorState.UPDATE) {
                        this.resultSet.absolute(this.row.getIndex() + 1);
                        this.resultSet.updateObject(this.index + 1, AccessorColumnUtil.renderColumnObject(this.definition, this.value));
                        this.resultSet.updateRow();
                        this.state = ResultAccessorState.STATIC;
                        break block9;
                    }
                    if (this.state == ResultAccessorState.STATIC) break block9;
                }
                catch (Exception e) {
                    this.state = this.state == ResultAccessorState.INSERT ? ResultAccessorState.INSERT_ERROR : (this.state == ResultAccessorState.INSERT_ERROR ? ResultAccessorState.INSERT_ERROR : ResultAccessorState.UPDATE_ERROR);
                    this.error = new DatabaseError(this.row.getIndex(), this.index, e);
                    Object var4_5 = null;
                    if (!this.validateStateListener()) return;
                    this.listener.columnChanged(this.row.getIndex(), this.index);
                    return;
                }
            }
            Object var4_4 = null;
            if (!this.validateStateListener()) return;
            this.listener.columnChanged(this.row.getIndex(), this.index);
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (!this.validateStateListener()) throw throwable;
            this.listener.columnChanged(this.row.getIndex(), this.index);
            throw throwable;
        }
    }

    public ResultColumnDefinition getDefinition() {
        return this.definition;
    }

    public int getIndex() {
        return this.index;
    }

    public int getRowIndex() {
        return this.row.getIndex();
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (this.value == null && value == null || this.value != null && this.value.equals(value)) {
            return;
        }
        if (this.state != ResultAccessorState.REMOVED && this.state != ResultAccessorState.DELETE && this.state != ResultAccessorState.INSERT) {
            if (this.state == ResultAccessorState.UPDATE) {
                this.state = ResultAccessorState.UPDATE;
                this.row.state = ResultAccessorState.UPDATE;
            } else if (this.state == ResultAccessorState.INSERT) {
                this.state = ResultAccessorState.UPDATE;
                this.row.state = ResultAccessorState.UPDATE;
            } else if (this.state == ResultAccessorState.STATIC) {
                this.state = ResultAccessorState.UPDATE;
                this.row.state = ResultAccessorState.UPDATE;
            }
        }
        this.value = value;
        if (this.validateStateListener()) {
            this.listener.columnChanged(this.row.getIndex(), this.index);
        }
    }

    void setRow(ResultRow row) {
        this.row = row;
    }

    void setIndex(int resultColumnIndex) {
        this.index = resultColumnIndex;
    }

    public String toString() {
        return this.value == null ? null : this.value.toString();
    }
}

