/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.exception.DatabaseSessionException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

public class DatabaseSpecification {
    private DatabaseSession session;

    public DatabaseSpecification(DatabaseSession session) {
        this.session = session;
    }

    private DatabaseSpecification() {
        this(null);
    }

    private DatabaseMetaData getDatabaseMetaData() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database meta data.", e);
        }
    }

    public int getDefaultTransactionIsolation() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getDefaultTransactionIsolation();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get default transaction isolation.", e);
        }
    }

    public String getDefaultTransactionIsolationName() throws DatabaseSessionException, ResultSetAccessException {
        int type = this.getDefaultTransactionIsolation();
        if (type == 0) {
            return "Connection.TRANSACTION_NONE";
        }
        if (type == 2) {
            return "Connection.TRANSACTION_READ_COMMITTED";
        }
        if (type == 1) {
            return "Connection.TRANSACTION_READ_UNCOMMITTED";
        }
        if (type == 4) {
            return "Connection.TRANSACTION_REPEATABLE_READ";
        }
        if (type == 8) {
            return "Connection.TRANSACTION_SERIALIZABLE";
        }
        return "Unkown";
    }

    public int getMaxBinaryLiteralLength() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxBinaryLiteralLength();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxCatalogNameLength() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxCatalogNameLength();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxCharLiteralLength() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxCharLiteralLength();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxColumnNameLength() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxColumnNameLength();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxColumnsInGroupBy() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxColumnsInGroupBy();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxColumnsInIndex() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxColumnsInIndex();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxColumnsInOrderBy() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxColumnsInOrderBy();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxColumnsInSelect() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxColumnsInSelect();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxColumnsInTable() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxColumnsInTable();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxConnections() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxConnections();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxCursorNameLength() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxCursorNameLength();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxIndexLength() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxIndexLength();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxProcedureNameLength() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxProcedureNameLength();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxRowSize() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxRowSize();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxSchemaNameLength() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxSchemaNameLength();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxStatementLength() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxStatementLength();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxStatements() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxStatements();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxTableNameLength() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxTableNameLength();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxTablesInSelect() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxTablesInSelect();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getMaxUserNameLength() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getMaxUserNameLength();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public int getResultSetHoldability() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getResultSetHoldability();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public String getResultSetHoldabilityName() throws DatabaseSessionException, ResultSetAccessException {
        int type = this.getResultSetHoldability();
        if (type == 1) {
            return "ResultSet.HOLD_CURSORS_OVER_COMMIT";
        }
        if (type == 2) {
            return "ResultSet.CLOSE_CURSORS_AT_COMMIT";
        }
        return "Unkown";
    }

    public int getSQLStateType() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getSQLStateType();
        }
        catch (AbstractMethodError e) {
            return -1;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database specification.", e);
        }
    }

    public String getSQLStateTypeName() throws DatabaseSessionException, ResultSetAccessException {
        int type = this.getSQLStateType();
        if (type == 1) {
            return "sqlStateXOpen";
        }
        if (type == 2) {
            return "sqlStateSQL99";
        }
        return "Unkown";
    }
}

