/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.eswing;

import javax.swing.BoundedRangeModel;
import javax.swing.JProgressBar;
import org.phosphoresce.commons.eswing.core.ESwingComponent;

public class EProgressBar
extends JProgressBar
implements ESwingComponent {
    private Thread extendIndeterminateThread = null;
    private boolean extendIndeterminate = false;
    private int extendIndeterminateCount = 0;
    private int extendIndeterminateBackupMaximum = 0;
    private int extendIndeterminateBackupMinimum = 0;
    private int extendIndeterminateBackupValue = 0;

    public void dressup() {
        this.getToolkit().setDynamicLayout(true);
        this.setDoubleBuffered(true);
    }

    public EProgressBar() {
        this.dressup();
    }

    public EProgressBar(BoundedRangeModel model) {
        super(model);
        this.dressup();
    }

    public EProgressBar(int orient, int min, int max) {
        super(orient, min, max);
        this.dressup();
    }

    public EProgressBar(int min, int max) {
        super(min, max);
        this.dressup();
    }

    public EProgressBar(int orient) {
        super(orient);
        this.dressup();
    }

    public void setExtendIndeterminate(boolean extendIndeterminate) {
        if (this.extendIndeterminate != extendIndeterminate) {
            this.extendIndeterminate = extendIndeterminate;
            this.extendIndeterminateCount = 0;
            if (extendIndeterminate) {
                this.extendIndeterminateBackupMaximum = this.getMaximum();
                this.extendIndeterminateBackupMinimum = this.getMinimum();
                this.extendIndeterminateBackupValue = this.getValue();
                this.setMaximum(100);
                this.setMinimum(0);
                this.setValue(this.extendIndeterminateCount);
                if (this.extendIndeterminateThread == null) {
                    this.extendIndeterminateThread = new Thread(new IndeterminateThread());
                    this.extendIndeterminateThread.start();
                }
            } else {
                this.setMaximum(this.extendIndeterminateBackupMaximum);
                this.setMinimum(this.extendIndeterminateBackupMinimum);
                this.setValue(this.extendIndeterminateBackupValue);
                this.extendIndeterminateBackupMaximum = 0;
                this.extendIndeterminateBackupMinimum = 0;
                this.extendIndeterminateBackupValue = 0;
                this.extendIndeterminateThread = null;
            }
        }
    }

    private void setValue(int n, boolean backup) {
        if (backup) {
            this.extendIndeterminateBackupValue = n;
        } else {
            super.setValue(n);
        }
    }

    public void setValue(int n) {
        this.setValue(n, this.extendIndeterminate);
    }

    public int getMaximum() {
        if (this.extendIndeterminate) {
            return this.extendIndeterminateBackupMaximum;
        }
        return super.getMaximum();
    }

    public int getMinimum() {
        if (this.extendIndeterminate) {
            return this.extendIndeterminateBackupMinimum;
        }
        return super.getMinimum();
    }

    public int getValue() {
        if (this.extendIndeterminate) {
            return this.extendIndeterminateBackupValue;
        }
        return super.getValue();
    }

    public void setMaximum(int n) {
        if (this.extendIndeterminate) {
            this.extendIndeterminateBackupMaximum = n;
        } else {
            super.setMaximum(n);
        }
    }

    public void setMinimum(int n) {
        if (this.extendIndeterminate) {
            this.extendIndeterminateBackupMinimum = n;
        } else {
            super.setMinimum(n);
        }
    }

    private class IndeterminateThread
    implements Runnable {
        private IndeterminateThread() {
        }

        public void run() {
            while (EProgressBar.this.extendIndeterminate) {
                try {
                    EProgressBar.this.setValue(EProgressBar.this.extendIndeterminateCount += 10, false);
                    if (EProgressBar.this.extendIndeterminateCount >= 100) {
                        EProgressBar.this.extendIndeterminateCount = 0;
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

