/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.window.main;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JMenuBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EFrame;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.dbbrowser.DatabaseBrowser;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.common.FrameStatusBarPanel;
import org.phosphoresce.dbbrowser.gui.window.main.DatabaseBrowserMenuBar;
import org.phosphoresce.dbbrowser.gui.window.main.DatabaseBrowserPane;
import org.phosphoresce.dbbrowser.gui.window.main.DatabaseBrowserTabbedPane;
import org.phosphoresce.dbbrowser.resource.image.DatabaseBrowserImages;

public final class DatabaseBrowserFrame
extends EFrame
implements RefreshableComponent {
    private Log log = LogFactory.getLog(this.getClass());
    private static DatabaseBrowserFrame instance = null;
    private EPanel mainContainerPanel = null;

    private DatabaseBrowserFrame() {
        this.initialize();
    }

    public static DatabaseBrowserFrame instance() {
        if (instance == null) {
            instance = new DatabaseBrowserFrame();
        }
        return instance;
    }

    private void initialize() {
        this.setContentPane((Container)this.getMainContainerPanel());
        this.setIconImage(DatabaseBrowserImages.IMAGE_APP_ICON_32);
        this.setJMenuBar((JMenuBar)((Object)DatabaseBrowserMenuBar.instance()));
        this.setTitle("Database Browser");
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DatabaseBrowser.exit();
            }
        });
        this.setSize(new Dimension(900, 700));
    }

    public void refresh() throws Throwable {
        DatabaseBrowserTabbedPane.instance().refresh();
    }

    private EPanel getMainContainerPanel() {
        if (this.mainContainerPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.mainContainerPanel = new EPanel();
            this.mainContainerPanel.setLayout((LayoutManager)new GridBagLayout());
            this.mainContainerPanel.add((Component)((Object)DatabaseBrowserPane.instance()), (Object)gridBagConstraints);
            this.mainContainerPanel.add((Component)((Object)FrameStatusBarPanel.instance()), (Object)gridBagConstraints2);
        }
        return this.mainContainerPanel;
    }
}

