/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.common.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EButton;
import org.phosphoresce.commons.eswing.EDialog;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.EProgressBar;
import org.phosphoresce.dbbrowser.gui.common.window.ProcessAction;

public class ProcessDialog
extends EDialog {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Thread thread;
    private EPanel contentsPanel = null;
    private EProgressBar progressbar = null;
    private EButton cancelButton = null;

    private ProcessDialog() {
        this.initialize();
    }

    private ProcessDialog(Dialog owner) {
        super(owner, true);
        this.initialize();
    }

    private ProcessDialog(Frame owner) {
        super(owner, true);
        this.initialize();
    }

    public static void execute(Frame owner, ProcessAction runnable, boolean cancelable) {
        ProcessDialog frame = new ProcessDialog(owner);
        runnable.setFrame(frame);
        frame.thread = new Thread(runnable);
        frame.cancelButton.setEnabled(cancelable);
        frame.setVisible(true);
    }

    public static void execute(Frame owner, ProcessAction runnable) {
        ProcessDialog.execute(owner, runnable, true);
    }

    public void setVisible(boolean visible) {
        if (visible && this.thread != null) {
            this.thread.start();
        }
        super.setVisible(visible);
    }

    private void initialize() {
        this.setContentPane((Container)this.getContentsPanel());
        this.setTitle("Database Browser");
        this.setDefaultCloseOperation(0);
        this.setSize(new Dimension(480, 150));
        this.setLocationRelativeTo(this.getParent());
    }

    private EPanel getContentsPanel() {
        if (this.contentsPanel == null) {
            this.contentsPanel = new EPanel();
            this.contentsPanel.setLayout(null);
            this.contentsPanel.add((Component)this.getProgressbar(), null);
            this.contentsPanel.add((Component)this.getCancelButton(), null);
        }
        return this.contentsPanel;
    }

    private EProgressBar getProgressbar() {
        if (this.progressbar == null) {
            this.progressbar = new EProgressBar();
            this.progressbar.setBounds(new Rectangle(14, 63, 446, 14));
            this.progressbar.setIndeterminate(true);
        }
        return this.progressbar;
    }

    private EButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new EButton();
            this.cancelButton.setBounds(new Rectangle(194, 88, 86, 24));
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProcessDialog.this.thread.interrupt();
                    ProcessDialog.this.thread = null;
                    ProcessDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }
}

