/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.border.MatteBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EMessageDialog;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.EProgressBar;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

public final class FrameStatusBarPanel
extends EPanel
implements RefreshableComponent {
    private Log log = LogFactory.getLog(this.getClass());
    private static FrameStatusBarPanel instance = null;
    private Thread refreshThread = null;
    private ELabel statusBarSpacer = null;
    private NumberFormat memoryNumberFormat = null;
    private ELabel memoryBarLabel = null;
    private EProgressBar memoryBar = null;
    private ELabel jdbcUrlLabel = null;

    private FrameStatusBarPanel() {
        this.initialize();
        this.refreshThread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        FrameStatusBarPanel.this.refresh();
                        Thread.sleep(500L);
                    }
                }
                catch (Throwable throwable) {
                    String errorMessage = "failed to refresh status bar.<br>stoped refresh thread.";
                    FrameStatusBarPanel.this.log.error((Object)errorMessage, throwable);
                    EMessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), (String)errorMessage, (Throwable)throwable);
                    return;
                }
            }
        });
        this.refreshThread.start();
    }

    public static FrameStatusBarPanel instance() {
        if (instance == null) {
            instance = new FrameStatusBarPanel();
        }
        return instance;
    }

    public void refresh() throws Throwable {
        if (DatabaseBrowserSession.instance().getConfig() != null) {
            double totalMemory = (double)Runtime.getRuntime().totalMemory() / 1024.0 / 1024.0;
            double maxMemory = (double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0;
            double freeMemory = (double)Runtime.getRuntime().freeMemory() / 1024.0 / 1024.0;
            double usedMemory = totalMemory - freeMemory;
            this.getMemoryBar().setMinimum(0);
            this.getMemoryBar().setMaximum((int)totalMemory);
            this.getMemoryBar().setValue((int)usedMemory);
            this.getMemoryBar().setString(this.getMemoryNumberFormat().format(freeMemory) + " MB");
            this.getJdbcUrlLabel().setText(DatabaseBrowserSession.instance().getConfig().getJdbcUrl());
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints11.weightx = 0.0;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints1.weightx = 0.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(600, 20));
        this.setPreferredSize(new Dimension(600, 20));
        this.setMinimumSize(new Dimension(600, 20));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add((Component)this.getStatusBarSpacer(), gridBagConstraints);
        this.add((Component)this.getMemoryBarLabel(), gridBagConstraints1);
        this.add((Component)this.getMemoryBar(), gridBagConstraints2);
        this.add((Component)this.getJdbcUrlLabel(), gridBagConstraints11);
        this.setBorder(new MatteBorder(1, 0, 0, 0, Color.GRAY));
    }

    private ELabel getStatusBarSpacer() {
        if (this.statusBarSpacer == null) {
            this.statusBarSpacer = new ELabel();
        }
        return this.statusBarSpacer;
    }

    private NumberFormat getMemoryNumberFormat() {
        if (this.memoryNumberFormat == null) {
            this.memoryNumberFormat = new DecimalFormat("0.00");
        }
        return this.memoryNumberFormat;
    }

    private ELabel getMemoryBarLabel() {
        if (this.memoryBarLabel == null) {
            this.memoryBarLabel = new ELabel();
            this.memoryBarLabel.setText("Free Memory ");
        }
        return this.memoryBarLabel;
    }

    private EProgressBar getMemoryBar() {
        if (this.memoryBar == null) {
            this.memoryBar = new EProgressBar();
            this.memoryBar.setPreferredSize(new Dimension(80, 12));
            this.memoryBar.setMaximumSize(new Dimension(80, 12));
            this.memoryBar.setMinimumSize(new Dimension(80, 12));
            this.memoryBar.setStringPainted(true);
            this.memoryBar.setFont(new Font("Tahoma", 0, 10));
            this.memoryBar.setString("");
        }
        return this.memoryBar;
    }

    private ELabel getJdbcUrlLabel() {
        if (this.jdbcUrlLabel == null) {
            this.jdbcUrlLabel = new ELabel();
        }
        return this.jdbcUrlLabel;
    }
}

