/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.config;

import java.io.Serializable;
import org.phosphoresce.commons.util.StringUtil;
import org.phosphoresce.dbbrowser.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DatabaseBrowserWindowComponentConfig
implements Serializable {
    public static final String NODE_NAME = "windowComponent";
    private int messagePaneLocation;

    DatabaseBrowserWindowComponentConfig() {
    }

    DatabaseBrowserWindowComponentConfig(Node root) {
        this.load(root);
    }

    private void initialize() {
        this.messagePaneLocation = 600;
    }

    void save(Document document, Node root) {
        Node node = root.appendChild(document.createElement(NODE_NAME));
        Node messagePaneLocation = node.appendChild(document.createElement("messagePaneLocation"));
        messagePaneLocation.appendChild(document.createTextNode(StringUtil.valueOf((int)this.getWindowMessagePaneLocation())));
    }

    void load(Node root) {
        NodeList nodeList = root.getChildNodes();
        this.initialize();
        for (int i = 0; i <= nodeList.getLength() - 1; ++i) {
            Node node = nodeList.item(i);
            if (!"messagePaneLocation".equals(node.getNodeName())) continue;
            this.messagePaneLocation = StringUtil.parsePrimitiveInt((String)XMLUtil.getTextContent(node));
        }
    }

    public int getWindowMessagePaneLocation() {
        return this.messagePaneLocation;
    }

    public void setWindowMessagePaneLocation(int messagePaneLocation) {
        this.messagePaneLocation = messagePaneLocation;
    }
}

