/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.config;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.dbbrowser.config.DatabaseBrowserConnectionConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DatabaseBrowserDefinitionedConnectionConfig
implements Serializable {
    public static final String NODE_NAME = "definitionedConnection";
    private List databaseConfigDefinitionList;

    DatabaseBrowserDefinitionedConnectionConfig() {
    }

    private void initialize() {
        this.databaseConfigDefinitionList = null;
    }

    void save(Document document, Node root) {
        Node node = root.appendChild(document.createElement(NODE_NAME));
        Iterator iterator = this.getDatabaseConfigDefinitionList().iterator();
        while (iterator.hasNext()) {
            DatabaseBrowserConnectionConfig connectionConfig = (DatabaseBrowserConnectionConfig)iterator.next();
            connectionConfig.save(document, node);
        }
    }

    void load(Node root) {
        NodeList nodeList = root.getChildNodes();
        this.initialize();
        for (int i = 0; i <= nodeList.getLength() - 1; ++i) {
            Node node = nodeList.item(i);
            if (!"databaseConfig".equals(node.getNodeName())) continue;
            this.getDatabaseConfigDefinitionList().add(new DatabaseBrowserConnectionConfig(node));
        }
    }

    public List getDatabaseConfigDefinitionList() {
        if (this.databaseConfigDefinitionList == null) {
            this.databaseConfigDefinitionList = new LinkedList();
        }
        return this.databaseConfigDefinitionList;
    }

    public void setDatabaseConfigDefinitionList(List databaseConfigDefinitionList) {
        this.databaseConfigDefinitionList = databaseConfigDefinitionList;
    }

    public DatabaseConfig getDatabaseConfig(String name) {
        Iterator iterator = this.getDatabaseConfigDefinitionList().iterator();
        while (iterator.hasNext()) {
            DatabaseBrowserConnectionConfig connectionConfig = (DatabaseBrowserConnectionConfig)iterator.next();
            if (!name.equals(connectionConfig.getName())) continue;
            return connectionConfig.getDatabaseConfig();
        }
        return null;
    }

    public void addDatabaseConfig(String name, DatabaseConfig config) {
        DatabaseBrowserConnectionConfig connectionConfig = new DatabaseBrowserConnectionConfig();
        connectionConfig.setName(name);
        connectionConfig.setDatabaseConfig(config);
        this.getDatabaseConfigDefinitionList().add(connectionConfig);
    }
}

