/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.config;

import java.io.FileOutputStream;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.dbbrowser.config.DatabaseBrowserDefinitionedConnectionConfig;
import org.phosphoresce.dbbrowser.config.DatabaseBrowserRecentConnectionConfig;
import org.phosphoresce.dbbrowser.config.DatabaseBrowserWindowConfig;
import org.phosphoresce.dbbrowser.exception.BrowserConfigException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DatabaseBrowserConfig
implements Serializable {
    public static final String NODE_NAME = "configuration";
    private static transient Log log = LogFactory.getLog((Class)DatabaseBrowserConfig.class);
    private static transient DatabaseBrowserConfig instance = null;
    private DatabaseBrowserDefinitionedConnectionConfig definitionedConnectionConfig = null;
    private DatabaseBrowserRecentConnectionConfig recentConnectionConfig = null;
    private DatabaseBrowserWindowConfig windowConfig = null;

    private DatabaseBrowserConfig() {
    }

    public static DatabaseBrowserConfig instance() {
        if (instance == null) {
            instance = new DatabaseBrowserConfig();
        }
        return instance;
    }

    public void save() throws BrowserConfigException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Node root = document.appendChild(document.createElement(NODE_NAME));
            this.getWindowConfig().save(document, root);
            this.getRecentConnectionConfig().save(document, root);
            this.getDefinitionedConnectionConfig().save(document, root);
            FileOutputStream stream = new FileOutputStream("dbbrowser-config.xml");
            StreamSource xslt = new StreamSource(this.getClass().getResourceAsStream("/org/phosphoresce/dbbrowser/config/DatabaseBrowserConfig.xsl"));
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xslt);
            transformer.transform(new DOMSource(document), new StreamResult(stream));
            stream.close();
        }
        catch (Throwable throwable) {
            log.warn((Object)"failed to save configuration.", throwable);
        }
    }

    public void load() throws BrowserConfigException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse("dbbrowser-config.xml");
            Element root = document.getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i <= nodeList.getLength() - 1; ++i) {
                Node node = nodeList.item(i);
                if ("windowConfig".equals(node.getNodeName())) {
                    this.getWindowConfig().load(node);
                    continue;
                }
                if ("recentConnection".equals(node.getNodeName())) {
                    this.getRecentConnectionConfig().load(node);
                    continue;
                }
                if (!"definitionedConnection".equals(node.getNodeName())) continue;
                this.getDefinitionedConnectionConfig().load(node);
            }
        }
        catch (Throwable throwable) {
            log.warn((Object)"failed to load configuration.", throwable);
        }
    }

    public DatabaseBrowserDefinitionedConnectionConfig getDefinitionedConnectionConfig() {
        if (this.definitionedConnectionConfig == null) {
            this.definitionedConnectionConfig = new DatabaseBrowserDefinitionedConnectionConfig();
        }
        return this.definitionedConnectionConfig;
    }

    public void setDefinitionedConnectionConfig(DatabaseBrowserDefinitionedConnectionConfig definitionedConnectionConfig) {
        this.definitionedConnectionConfig = definitionedConnectionConfig;
    }

    public DatabaseBrowserRecentConnectionConfig getRecentConnectionConfig() {
        if (this.recentConnectionConfig == null) {
            this.recentConnectionConfig = new DatabaseBrowserRecentConnectionConfig();
        }
        return this.recentConnectionConfig;
    }

    public void setRecentConnectionConfig(DatabaseBrowserRecentConnectionConfig recentConnectionConfig) {
        this.recentConnectionConfig = recentConnectionConfig;
    }

    public DatabaseBrowserWindowConfig getWindowConfig() {
        if (this.windowConfig == null) {
            this.windowConfig = new DatabaseBrowserWindowConfig();
        }
        return this.windowConfig;
    }

    public void setWindowConfig(DatabaseBrowserWindowConfig windowConfig) {
        this.windowConfig = windowConfig;
    }
}

