package jp.gr.java_conf.miya.pglauncher.actions;

import java.io.File;
import java.io.IOException;

import jp.gr.java_conf.miya.pglauncher.PGLauncherPlugin;
import jp.gr.java_conf.miya.pglauncher.common.Const;
import jp.gr.java_conf.miya.pglauncher.utils.ImageUtils;
import jp.gr.java_conf.miya.pglauncher.utils.LocalUtils;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.WorkbenchWindow;


public class ProgramAction extends Action {
	
	//======================================================================
	// Instance Variable
	//======================================================================
	//------------------------------------------------------------ private
	private String path_;
	private String arg_;
	private boolean isExe_;
	private String extension_;
	
	//======================================================================
	// Constructor
	//======================================================================
	//------------------------------------------------------------ public
	public ProgramAction(String name, String path, String arg){
		setText(name);
		path_ = path;
		arg_ = arg;
		extension_ = path_.substring(path_.lastIndexOf(".") + 1); //$NON-NLS-1$
		
		ImageDescriptor imgDesc = ImageUtils.getImageDescriptorFromProgram(path);
		if(imgDesc == null){
			String extension = path.substring(path.lastIndexOf(".") + 1); //$NON-NLS-1$
			if(extension.equalsIgnoreCase(Const.EXT_EXE)){
				imgDesc = ImageUtils.getImageDescriptorFromIcon(Const.ICON_EXE);
			}else{
				imgDesc = ImageUtils.getImageDescriptorFromIcon(Const.ICON_UNKOWN);
			}
		}
		setImageDescriptor(imgDesc);
	}

	//======================================================================
	// Instance Method
	//======================================================================
	//------------------------------------------------------------ public
	public void run(){
		
		WorkbenchWindow workbenchWindow = (WorkbenchWindow)PGLauncherPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
		IStatusLineManager lineManager = workbenchWindow.getActionBars().getStatusLineManager();
		
		File file = new File(path_);
		if(!file.exists()){
			lineManager.setMessage(ImageUtils.getImageFromIcon(Const.ICON_ERROR),
									LocalUtils.getString("ProgramAction.error1",new String[]{getText()})); //$NON-NLS-1$
			return;
		}
		
		int delim = path_.lastIndexOf("\\"); //$NON-NLS-1$
		int slash = path_.lastIndexOf("/"); //$NON-NLS-1$
		if(slash > delim) delim = slash;
		File dir = new File(path_.substring(0,delim));
		
		String path = "\"" + path_ + "\""; //$NON-NLS-1$ //$NON-NLS-2$
		if(arg_ != null && !arg_.equals("")){ //$NON-NLS-1$
			path += " " + arg_; //$NON-NLS-1$
		}
		
		try{
			Process proc = null;
			if(extension_.equalsIgnoreCase(Const.EXT_EXE) ||
					extension_.equalsIgnoreCase(Const.EXT_BAT)){
				proc = Runtime.getRuntime().exec(path,null,dir);
			}else{
				if(Platform.getOS().equals(Platform.OS_WIN32)){
					proc = Runtime.getRuntime().exec("cmd /c start \"PGLauncher\" " + path,null,dir); //$NON-NLS-1$
				}else{
					proc = Runtime.getRuntime().exec(path,null,dir);
				}
			}
			lineManager.setMessage(ImageUtils.getImageFromIcon(Const.ICON_RUN),
					LocalUtils.getString("ProgramAction.run",new String[]{getText()})); //$NON-NLS-1$
		}catch(IOException e){
			lineManager.setMessage(ImageUtils.getImageFromIcon(Const.ICON_ERROR),
									LocalUtils.getString("ProgramAction.error2",new String[]{getText()})); //$NON-NLS-1$
		}
	}
}
