package jp.gr.java_conf.miya.pglauncher.actions;

import jp.gr.java_conf.miya.pglauncher.common.Const;
import jp.gr.java_conf.miya.pglauncher.dialogs.ConfigDialog;
import jp.gr.java_conf.miya.pglauncher.utils.ImageUtils;
import jp.gr.java_conf.miya.pglauncher.utils.LocalUtils;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Control;

public class ConfigAction extends Action {

	//======================================================================
	// Instance Variable
	//======================================================================
	//------------------------------------------------------------ private
	private Control control_;

	//======================================================================
	// Constructor
	//======================================================================
	//------------------------------------------------------------ public
	public ConfigAction(Control control){
		control_ = control;
		setText(LocalUtils.getString("ConfigAction.menuTitle")); //$NON-NLS-1$
		setImageDescriptor(ImageUtils.getImageDescriptorFromIcon(Const.ICON_CONFIG));
	}

	//======================================================================
	// Instance Method
	//======================================================================
	//------------------------------------------------------------ public
	public void run(){
		ConfigDialog dialog = new ConfigDialog(control_.getShell());
		dialog.open();
	}
}
