/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.miya.pglauncher.actions;

import java.io.File;
import java.io.IOException;
import jp.gr.java_conf.miya.pglauncher.PGLauncherPlugin;
import jp.gr.java_conf.miya.pglauncher.utils.ImageUtils;
import jp.gr.java_conf.miya.pglauncher.utils.LocalUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.WorkbenchWindow;

public class ProgramAction
extends Action {
    private String path_;
    private String arg_;
    private boolean isExe_;
    private String extension_;

    public ProgramAction(String name, String path, String arg) {
        this.setText(name);
        this.path_ = path;
        this.arg_ = arg;
        this.extension_ = this.path_.substring(this.path_.lastIndexOf(".") + 1);
        ImageDescriptor imgDesc = ImageUtils.getImageDescriptorFromProgram(path);
        if (imgDesc == null) {
            String extension = path.substring(path.lastIndexOf(".") + 1);
            imgDesc = extension.equalsIgnoreCase("exe") ? ImageUtils.getImageDescriptorFromIcon("exe") : ImageUtils.getImageDescriptorFromIcon("unknown");
        }
        this.setImageDescriptor(imgDesc);
    }

    public void run() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PGLauncherPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        IStatusLineManager lineManager = workbenchWindow.getActionBars().getStatusLineManager();
        File file = new File(this.path_);
        if (!file.exists()) {
            lineManager.setMessage(ImageUtils.getImageFromIcon("error"), LocalUtils.getString("ProgramAction.error1", new String[]{this.getText()}));
            return;
        }
        int delim = this.path_.lastIndexOf("\\");
        int slash = this.path_.lastIndexOf("/");
        if (slash > delim) {
            delim = slash;
        }
        File dir = new File(this.path_.substring(0, delim));
        String path = "\"" + this.path_ + "\"";
        if (this.arg_ != null && !this.arg_.equals("")) {
            path = String.valueOf(path) + " " + this.arg_;
        }
        try {
            if (this.extension_.equalsIgnoreCase("exe") || this.extension_.equalsIgnoreCase("bat")) {
                Runtime.getRuntime().exec(path, null, dir);
            } else if (Platform.getOS().equals("win32")) {
                Runtime.getRuntime().exec("cmd /c start \"PGLauncher\" " + path, null, dir);
            } else {
                Runtime.getRuntime().exec(path, null, dir);
            }
            lineManager.setMessage(ImageUtils.getImageFromIcon("run"), LocalUtils.getString("ProgramAction.run", new String[]{this.getText()}));
        }
        catch (IOException iOException) {
            lineManager.setMessage(ImageUtils.getImageFromIcon("error"), LocalUtils.getString("ProgramAction.error2", new String[]{this.getText()}));
        }
    }
}

