/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.miya.pglauncher.actions;

import jp.gr.java_conf.miya.pglauncher.actions.AbstractAction;
import jp.gr.java_conf.miya.pglauncher.actions.ActionEventProvider;
import jp.gr.java_conf.miya.pglauncher.dialogs.ConfigDialog;
import jp.gr.java_conf.miya.pglauncher.utils.LocalUtils;
import jp.gr.java_conf.miya.pglauncher.utils.TreeUtils;
import jp.gr.java_conf.miya.pglauncher.utils.XMLUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class DeleteAction
extends AbstractAction {
    private ConfigDialog dialog_;
    private TreeViewer viewer_;

    public DeleteAction(ConfigDialog dialog, TreeViewer viewer, ActionEventProvider provider) {
        super(LocalUtils.getString("DeleteAction.menuTitle"), null, provider);
        this.dialog_ = dialog;
        this.viewer_ = viewer;
    }

    public void run() {
        Element el = TreeUtils.getSelectedElement(this.viewer_);
        String type = el.getNodeName();
        if (type.equals("pglauncher")) {
            return;
        }
        NamedNodeMap map = el.getAttributes();
        String name = map.getNamedItem("name").getNodeValue();
        String message = null;
        message = type.equals("group") ? LocalUtils.getString("DeleteAction.confirm1", new String[]{name}) : LocalUtils.getString("DeleteAction.confirm2", new String[]{name});
        if (MessageDialog.openQuestion((Shell)this.viewer_.getControl().getShell(), (String)LocalUtils.getString("DeleteAction.titlebar"), (String)message)) {
            Element parent = (Element)el.getParentNode();
            Document document = (Document)this.viewer_.getInput();
            XMLUtils.removeNode(document, el);
            this.viewer_.refresh();
            this.viewer_.setSelection((ISelection)new StructuredSelection((Object)parent), true);
            this.dialog_.modified();
        }
    }

    public void doubleClick(Event event) {
    }

    public void rightClick(Event event) {
        Element el = TreeUtils.getSelectedElement(this.viewer_);
        String type = el.getNodeName();
        if (type.equals("pglauncher")) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void keyDown(Event event) {
        switch (event.keyCode) {
            case 127: {
                this.run();
            }
        }
    }
}

