package jp.gr.java_conf.miya.pglauncher.dialogs;

import java.util.ArrayList;
import java.util.List;

import jp.gr.java_conf.miya.pglauncher.actions.ActionEventProvider;
import jp.gr.java_conf.miya.pglauncher.actions.AddGroupAction;
import jp.gr.java_conf.miya.pglauncher.actions.AddProgramAction;
import jp.gr.java_conf.miya.pglauncher.actions.DeleteAction;
import jp.gr.java_conf.miya.pglauncher.actions.UpdateAction;
import jp.gr.java_conf.miya.pglauncher.common.Const;
import jp.gr.java_conf.miya.pglauncher.utils.ImageUtils;
import jp.gr.java_conf.miya.pglauncher.utils.XMLUtils;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigDialog extends TitleAreaDialog{
	
	//======================================================================
	// CX^Xϐ
	//======================================================================
	//------------------------------------------------------------ private
	private TreeViewer viewer_;
	private EventListener listener_;
	private ActionEventProvider provider_;
	private boolean isModified_ = false;
	
	//======================================================================
	// RXgN^
	//======================================================================
	//------------------------------------------------------------ public
	public ConfigDialog(Shell parent){
		super(parent);
	}
	
	//======================================================================
	// CX^X\bh
	//======================================================================
	//------------------------------------------------------------ public
	public void modified(){
		isModified_ = true;
	}
	
	//------------------------------------------------------------ protected
	protected void configureShell(Shell newShell){
		super.configureShell(newShell);
		newShell.setText("ݒ");
	}
	
	protected Point getInitialSize(){
		return new Point(400,500);
	}
	
	protected Control createDialogArea(Composite parent){
		Composite composite = (Composite)super.createDialogArea(parent);
		
		Composite contents = new Composite(composite,SWT.NONE);
		contents.setLayout(new GridLayout());
		contents.setLayoutData(new GridData(GridData.FILL_BOTH));
		_createTreeViewer(contents);
		_initDragAndDrop();
		
		setMessage("vO̓o^ECE폜s܂B", IMessageProvider.INFORMATION);
		
		return composite;
	}
	
	protected void okPressed(){
		XMLUtils.getInstance().saveDocument((Document)viewer_.getInput());
		super.okPressed();
	}
	
	protected void cancelPressed(){
		if(isModified_){
			if(!MessageDialog.openQuestion(
					viewer_.getControl().getShell(),
					"j̊mF",
					"ύXꂽݒjĂ낵łH")){
				return;
			}
			isModified_ = false;
		}
		viewer_.setInput(XMLUtils.getInstance().loadDocument());
		super.cancelPressed();
	}
	
	//------------------------------------------------------------ private
	private void _createTreeViewer(Composite parent){
		viewer_ = new TreeViewer(parent, SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
		viewer_.setContentProvider(new TreeContentProvider());
		viewer_.setLabelProvider(new TreeLabelProvider());
		viewer_.setInput(
				XMLUtils.getInstance().loadDocument());
		viewer_.getControl().setLayoutData(new GridData(GridData.FILL_BOTH));
		provider_ = new ActionEventProvider();
		_createMenu();
		_addListener();
		
		viewer_.expandAll();
	}
	
	private void _initDragAndDrop(){
		int ops = DND.DROP_MOVE;
		Transfer[] transfers = new Transfer[] { ProgramTransfer.getInstance()};
		viewer_.addDragSupport(ops, transfers, new ProgramDragListener(viewer_));
		transfers = new Transfer[] {ProgramTransfer.getInstance()};
		ProgramTreeDropAdapter dropAdapter = new ProgramTreeDropAdapter(this,viewer_);
		viewer_.addDropSupport(ops, transfers, dropAdapter);
	}
	
	private void _createMenu(){
		MenuManager menu = new MenuManager();
		viewer_.getTree().setMenu(menu.createContextMenu(viewer_.getTree()));
		
		menu.add(new AddProgramAction(this,viewer_, provider_));
		menu.add(new AddGroupAction(this,viewer_, provider_));
		menu.add(new Separator());
		menu.add(new UpdateAction(this,viewer_, provider_));
		menu.add(new DeleteAction(this,viewer_, provider_));
	}
	
	private void _addListener(){
		listener_ = new EventListener();
		viewer_.getTree().addListener(SWT.MenuDetect,listener_);
		viewer_.getTree().addListener(SWT.MouseDoubleClick,listener_);
		viewer_.getTree().addListener(SWT.KeyDown,listener_);
	}
	
	//======================================================================
	// NX
	//======================================================================
	static class TreeContentProvider implements ITreeContentProvider{
		public Object[] getChildren(Object parentElement){
			return getChildrenNodeArray((Node)parentElement);
		}
		public Object getParent(Object element){
			return ((Node)element).getParentNode();
		}
		public boolean hasChildren(Object element){
			return ((Node)element).hasChildNodes();
		}
		public Object[] getElements(Object inputElement){
			return getChildrenNodeArray((Node)inputElement);
		}
		public void dispose(){}
		public void inputChanged(Viewer viewer, 
									Object oldInput, 
									Object newInput) {}
		
		private Node[] getChildrenNodeArray(Node node){
			NodeList nodeList = node.getChildNodes();
			List validNodeList = new ArrayList();
			for (int i = 0; i < nodeList.getLength(); i++){
				if(nodeList.item(i).getNodeType() == Node.ELEMENT_NODE){
					validNodeList.add(nodeList.item(i));
				}
			}
			return (Node[])validNodeList.toArray(new Node[validNodeList.size()]);
		}
	}
	
	static class TreeLabelProvider extends LabelProvider{
		public String getText(Object element){
			Node node = (Node)element;
			if(node.getNodeName().equals(Const.NODE_ROOT)){
				return "PGLauncher";
			}
			NamedNodeMap map = ((Node)element).getAttributes();
			return map.getNamedItem(Const.ATTR_NAME).getNodeValue();
		}
		
		public Image getImage(Object element){
			Node node = (Node)element;
			String name = node.getNodeName();
			if(name.equals(Const.NODE_ROOT)){
				return ImageUtils.getImageFromIcon(Const.ICON_PGLAUNCHER);
			}else if(name.equals(Const.NODE_FOLDER)){
				return ImageUtils.getImageFromIcon(Const.ICON_FOLDER);
			}else if(name.equals(Const.NODE_GROUP)){
				return ImageUtils.getImageFromIcon(Const.ICON_GROUP);
			}
			NamedNodeMap map = ((Node)element).getAttributes();
			String path = map.getNamedItem(Const.ATTR_PATH).getNodeValue();
			Image img = ImageUtils.getImageFromProgram(path);
			if(img == null){
				String extension = path.substring(path.lastIndexOf(".") + 1);
				if(extension.equalsIgnoreCase(Const.EXT_EXE)){
					return ImageUtils.getImageFromIcon(Const.ICON_EXE);
				}else{
					return ImageUtils.getImageFromIcon(Const.ICON_UNKOWN);
				}
			}
			return img;
		}
	}
	
	class EventListener implements Listener{
		public void handleEvent(Event event){
			provider_.handleEvent(event,viewer_);
		}
	}
}
