package jp.gr.java_conf.miya.pglauncher;


import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import jp.gr.java_conf.miya.pglauncher.common.Const;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PGLauncherPlugin extends AbstractUIPlugin {

	//======================================================================
	// NXϐ
	//======================================================================
	//------------------------------------------------------------ private
	private static PGLauncherPlugin plugin;
	
	//======================================================================
	// CX^X\bh
	//======================================================================
	//------------------------------------------------------------ private
	private ResourceBundle resourceBundle;
	
	//======================================================================
	// RXgN^
	//======================================================================
	//------------------------------------------------------------ public
	public PGLauncherPlugin(){
		super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle.getBundle("jp.gr.java_conf.miya.pglauncher.PGLauncherPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	//======================================================================
	// CX^X\bh
	//======================================================================
	//------------------------------------------------------------ public
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}

	public static PGLauncherPlugin getDefault() {
		return plugin;
	}

	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	
	//======================================================================
	// NX\bh
	//======================================================================
	//------------------------------------------------------------ public
	public static String getResourceString(String key) {
		ResourceBundle bundle = PGLauncherPlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	public static File getConfigFile(){
		return plugin.getStateLocation().append("/").append(Const.FILENAME).toFile();
	}
}
