<?php
/*
 * This file is part of the pettiwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: pettiwork: the PHP lightweight web framework
 * File:    xbpwRequest.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: xbpwRequest.php 26 2008-07-19 04:47:18Z tshiro $
 * @copyright 2007-2008 Exbridge,Inc.
 */
class xbpwRequest
{
    /** invoked action name */
    var $_action = '';

    /** request parameters */
    var $_params = array();

    /**
     * Factory method.
     * @access public
     * @param string key for action value
     * @return reference for object
     */
    function &factory($action_key)
    {
        if (!is_string($action_key) || $action_key == '') {
            if (PW_EXCEPTION_DISABLED) {
                trigger_error("Invalid action key '" . $action_key . "' specified.", E_USER_ERROR);
            }
            else {
                throw new xbpwException(E_USER_ERROR, "Invalid action key '" . $action_key . "' specified.");
            }
        }
        $request = new xbpwRequest();

        if (isset($_GET[$action_key])) {
            $request->setAction($_GET[$action_key]);
        }
        else if (isset($_POST[$action_key])) {
            $request->setAction($_POST[$action_key]);
        }

        //postから取得し、getで上書き
        //jqueryなどのajax絡みでその方が無難なことが多い
        foreach ($_POST as $key => $value) {
            $request->setParam($key, $value);
        }
        foreach ($_GET as $key => $value) {
            $request->setParam($key, $value);
        }
        foreach ($_FILES as $key => $value) {
            if (is_array($value)) {
                $file = new xbpwUploadFile($value);
                $request->setParam($key, $file);
            } else {
                $request->setParam($key, $value);
            }
        }

        //静的変換用ルーティングファイルが存在した場合
        $_pw_routing_conf = PW_APP_CONFIG_DIR . DS . 'routing.inc';
        if (PW_PREFIX != '') {
            $_pw_routing_conf = PW_APP_CONFIG_DIR . DS . PW_PREFIX . DS . 'routing.inc';
        }
        if (file_exists($_pw_routing_conf)) {
            //debugLog($_SERVER['REQUEST_URI']);
            $routing = include($_pw_routing_conf);
            krsort($routing);
            $request_uri = explode('/', $_SERVER['REQUEST_URI']);

            $i = 0;
            //debugLog($request_uri);
            foreach ($request_uri as $val) {
                if (substr($val,strrpos($val, '.'))=='.php') {
                    break;
                }
                unset($request_uri[$i++]);
            }
            //debugLog($request_uri);

            $cnt = count($request_uri);
            $req_val = array();
            $i = 0;
            foreach ($request_uri as $val) {
                $req_val[$i++] = $val;
            }

            foreach ($routing as $key=>$val) {
                $route_key = explode('/', $key);
                $route_val = explode('/', $val);
                $route_key_tmp = array();
                foreach ($route_key as $key) {
                    if ($key != '?') {
                        $route_key_tmp[] = $key;
                    }
                }
                $key_cnt = count($route_key);
                $key_tmp_cnt = count($route_key_tmp);

                if ($cnt == $key_cnt) {
                    $match_flg = true;
                    for ($i=0; $i<$key_tmp_cnt; $i++) {
                        if ($route_key[$i]!=$req_val[$i]) {
                            $match_flg = false;
                        }
                    }

                    if ($match_flg) {
                        if ($key_tmp_cnt==1) {
                            $request->setAction('Default');
                        }
                        for ($i=0; $i<$cnt; $i++) {
                            if ($action_key==$route_val[$i]) {
                                $request->setAction($req_val[$i]);
                            }
                            //debugLog($route_val[$i] . '*' . $req_val[$i]);
                            $request->setParam($route_val[$i], $req_val[$i]);
                        }
                        break;
                    }
                }
            }
        }
        return $request;
    }

    /**
     * get action.
     * @access public
     */
    function getAction()
    {
        return $this->_action;
    }

    /**
     * set action.
     * @access public
     */
    function setAction($action)
    {
        $this->_action = $action;
    }

    /**
     * get param.
     * @access public
     */
    function getParam($key)
    {
        if (!array_key_exists($key, $this->params)) {
            return null;
        }
        return $this->_params[$key];
    }

    /**
     * set action.
     * @access public
     */
    function setParam($key, $val)
    {
        if (isMobile()) {
            $this->_params[$key] = mb_convert_encoding($val, PW_ENCODE, PW_MOBILE_ENCODE);
        }
        else {
            $this->_params[$key] = $val;
        }
    }

    /**
     * set param reference.
     * @access public
     */
    function setParamByReference($key, &$obj)
    {
        $this->_params[$key] = $obj;
    }

    /**
     * get param.
     * @access public
     */
    function getParameters()
    {
        return $this->_params;
    }

    /**
     * set param key names.
     * @access public
     */
    function getParamNames()
    {
        return array_keys($this->_params);
    }
}
