/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: FlowControlException.java,v 1.2 2006/11/04 04:29:07 akabane Exp $
 */
package org.logical_paradox.petitbasic.runtime.exception;

import org.logical_paradox.petitbasic.runtime.BasicCommandLine;

/**
 * t[OD
 * vOsɁC̍s֑JڂۂɔD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class FlowControlException extends BasicLanguageException {
	/** suid */
	private static final long serialVersionUID = 6071032812763733827L;
	/** Jڐsԍ */
	private int lineno;
	/** Jڐs|C^ */
	private int runptr = BasicCommandLine.RUNPTR_BEGIN;

	/**
	 * RXgN^
	 * @param lno Jڐsԍ
	 */
	public FlowControlException(int lno) {
		super(-1, lno);
		lineno = lno;
	}
	/**
	 * RXgN^D
	 * @param lno Jڐsԍ
	 * @param ptr Jڐs|C^
	 */
	public FlowControlException(int lno, int ptr) {
		super(-1, lno);
		lineno = lno;
		runptr = ptr;
	}
	/**
	 * JڐsԍԂD
	 * @return Jڐsԍ
	 */
	public int getLineno() {
		return lineno;
	}
	/**
	 * Jڐs|C^ԂD
	 * @return Jڐs|C^
	 */
	public int getRunPtr() {
		return runptr;
	}
}
