/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: BasicRuntimeContext.java,v 1.4 2006/12/10 15:23:07 akabane Exp $
 */
package org.logical_paradox.petitbasic.runtime;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Stack;

import org.logical_paradox.common.util.Context;

/**
 * BASICsnReLXgD
 * ̃ReLXǵCvO̎s1񂲂Ƃɐ/jD<br>
 * Ⴆ΂vORUNꍇCvOI܂ł́CReLXgCX^XgpD<br>
 * _CNg[h̏ꍇ́Cs̎sI܂ŃReLXgpD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class BasicRuntimeContext extends Context {
	/** ^CRtBO[V */
	public final BasicRuntimeConfig config;
	/** vOftO */
	public boolean breakFlag = false;
	/** ݎs̍sԍ(-1:_CNg[h) */
	private int lineno = -1;
	/** o̓Xg[ */
	private final OutputStream out;
	/** BASIC^C */
	private final BasicRuntimeEnvironment env;
	/** Ăяo\}bv */
	private HashMap callingStructureContext = new HashMap();

	/**
	 * RXgN^D
	 * @param e BASIC^C
	 * @param cfg ^CRtBO[V
	 * @param o o̓Xg[
	 */
	public BasicRuntimeContext(BasicRuntimeEnvironment e, BasicRuntimeConfig cfg, OutputStream o) {
		config = cfg;
		out = o;
		env = e;
	}
	/**
	 * ftHg̕ϐ^ԂD
	 * @return ftHg̕ϐ^
	 */
	public int getDefaultVarType() {
		return env.getDefaultValueType();
	}
	/**
	 * o̓Xg[ԂD
	 * @return o̓Xg[
	 */
	public OutputStream getOutputStream() {
		return out;
	}
	/**
	 * sԍݒ肷D
	 * @param lno sԍ
	 */
	public void setLineno(int lno) {
		lineno = lno;
	}
	/**
	 * sԍԂD
	 * @return sԍ
	 */
	public int getLineno() {
		return lineno;
	}
	/**
	 * Ăяo\ReLXgԂD
	 * ݂ȂꍇCIɐVReLXg쐬ĕԂD
	 * @param name ReLXg
	 * @return ReLXg(X^bN)
	 */
	public Stack getCallingStructureContext(String name) {
		Stack ctx = (Stack)callingStructureContext.get(name);
		if(ctx == null) {
			// ΉReLXgȂꍇCVK쐬ēo^
			ctx = new Stack();
			callingStructureContext.put(name, ctx);
		}

		return ctx;
	}
}
