/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: BasicErrorMessage.java,v 1.3 2007/12/03 17:30:21 akabane Exp $
 */
package org.logical_paradox.petitbasic.runtime;

import org.logical_paradox.common.message.MessageBuilder;
import org.logical_paradox.common.util.PropertyUtils;
import org.logical_paradox.common.util.StringUtils;

/**
 * BASICG[bZ[W\[XD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class BasicErrorMessage {
	/** G[bZ[W\[Xt@C */
	public static final String ERROR_MSG_FILENAME = "errormsg.properties";
	/** G[bZ[W - `G[ */
	public static final String MSG_UNPRINTABLE_ERROR = "Unprintable error";
	/** bZ[Wr_ */
	private static final MessageBuilder builder = new MessageBuilder(PropertyUtils.getResourceAsStream(ERROR_MSG_FILENAME));

	/**
	 * wR[hɑΉG[bZ[WԂD
	 * @param errorCode G[R[h
	 * @return bZ[W
	 */
	public static final String getMessage(int errorCode) {
		String msg = builder.getMessage("" + errorCode);
		if(StringUtils.isEmpty(msg)) {
			// `G[
			msg = MSG_UNPRINTABLE_ERROR;
		}
		return msg;
	}
}
