/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: RelationEqualOperation.java,v 1.3 2006/10/21 08:55:30 akabane Exp $
 */
package org.logical_paradox.petitbasic.operator.ro;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.Operation;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * ֌WZq''
 * PƑQl̏ꍇ-1CقȂꍇ0ԋpD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class RelationEqualOperation implements Operation {
	/**
	 * ZsD
	 * @param ctx BASIC^CReLXg
	 * @param v1 P(PZq̏ꍇnull)
	 * @param v2 Q
	 * @return vZ
	 * @throws BasicLanguageException vZɔG[Ȃ
	 */
	public Token doOperation(BasicRuntimeContext context, Token v1, Token v2) throws BasicLanguageException {
		// ̌^̔r(vȂꍇType mismatch)
		OperationUtils.compareValueType(v1, v2, context);

		boolean compareResult = v1.toString().equals(v2.toString());

		// rʂԂ(-1:true 0:false)
		Token token = new Token(Token.TYPE_LITERAL);
		token.setIntValue(compareResult ? -1 : 0);
		token.setValueType(Token.VTYPE_INT);

		return token;
	}
}
