/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: MinusSignOperation.java,v 1.2 2006/10/21 08:55:30 akabane Exp $
 */
package org.logical_paradox.petitbasic.operator;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * }CiXD
 * 𔽓]D
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class MinusSignOperation implements Operation {
	/**
	 * ZsD
	 * @param ctx BASIC^CReLXg
	 * @param v1 P(PZq̏ꍇnull)
	 * @param v2 Q
	 * @return vZ
	 * @throws BasicLanguageException vZɔG[Ȃ
	 */
	public Token doOperation(BasicRuntimeContext context, Token v1, Token v2) throws BasicLanguageException {
		if(
			v2.getValueType() == Token.VTYPE_STR ||
			(v2.getValueType() == Token.VTYPE_DEF && context.getDefaultVarType() == Token.VTYPE_STR)
		) {
			// ^̂type mismatch
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH);
		}
		Token token = new Token(Token.TYPE_LITERAL);
		token.setValueType(v2.getValueType());
		token.setDecimalFormat(v2.getDecimalFormat());

		if(v2.getValueType() == Token.VTYPE_INT) {
			// PȂ鐮̏ꍇ-1|Z邾
			long ans = v2.getIntValue() * -1;
			token.setIntValue(ans);
		} else {
			// ]
			Real real = new Real(v2.getRealValue());
			real.setPositive(real.isPositive() == false);
			token.setRealValue(real);
		}
		return token;
	}

}
