/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: IntegerDivisionOperation.java,v 1.4 2006/10/21 08:55:30 akabane Exp $
 */
package org.logical_paradox.petitbasic.operator;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * ZZqD
 * PƑQ𐮐ZĕԂD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class IntegerDivisionOperation implements Operation {
	/**
	 * ZsD
	 * @param ctx BASIC^CReLXg
	 * @param v1 P(PZq̏ꍇnull)
	 * @param v2 Q
	 * @return vZ
	 * @throws BasicLanguageException vZɔG[Ȃ
	 */
	public Token doOperation(BasicRuntimeContext context, Token v1, Token v2) throws BasicLanguageException {
		if(OperationUtils.isStringValueType(v1.getValueType(), v2.getValueType(), context.getDefaultVarType())) {
			// ^̂type mismatch
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH);
		}

		Token token = new Token(Token.TYPE_LITERAL);
		token.setDecimalFormat(Token.DF_INT);

		if(v1.getValueType() == Token.VTYPE_INT && v2.getValueType() == Token.VTYPE_INT) {
			// m͐ŌvZ
			try {
				token.setIntValue(v1.getIntValue() / v2.getIntValue());
				token.setValueType(Token.VTYPE_INT);
			} catch(ArithmeticException e) {
				// 0Z
				throw new BasicLanguageException(ErrorCodeConstant.DIVISION_BY_ZERO);
			}
		} else {
			// ̏ꍇBCDZ
			Real answer = context.config.mathpack.fp_DIVI(v1.getRealValue(), v2.getRealValue());

			if(answer == null) {
				// 0Z
				throw new BasicLanguageException(ErrorCodeConstant.DIVISION_BY_ZERO);
			}
			token.setRealValue(answer);
			token.setValueType(Token.VTYPE_DBL);
		}

		return token;
	}

}
