/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ReservedWordProcessor.java,v 1.6 2008/11/27 17:09:52 akabane Exp $
 */
package org.logical_paradox.petitbasic.lex.fsm.rw;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.logical_paradox.common.fsm.Symbol;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.petitbasic.BuiltinCommandLibrary;
import org.logical_paradox.petitbasic.lex.Lex;
import org.logical_paradox.petitbasic.lex.SyntaxConstant;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.lex.fsm.AbstractProcessor;
import org.logical_paradox.petitbasic.lex.fsm.CharacterSymbol;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * \邽߂̗LԑJڋ@BD
 * \܂͕ϐ擾D
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.6 $
 */
public class ReservedWordProcessor extends AbstractProcessor {
	/** ̃^Cv - \ */
	public static final int E_RESERVED_WORD = 1;
	/** ̃^Cv - ubN */
	public static final int E_BLOCK = 2;
	/** ̃^Cv - ϐ */
	public static final int E_VARIABLE = 99;

	/** ̓obt@ */
	private StringBuffer sb = new StringBuffer();
	/** ϐobt@ */
	private StringBuffer vb = new StringBuffer();
	/** 󗝂ꂽ̃^Cv */
	private int tokenType = E_VARIABLE;
	/** zϐǂ(true:z / false:ʏ) */
	private boolean array = false;
	/** ^ */
	private int valueType = Token.VTYPE_DEF;
	
	/** R[hubN̊Jn^ȈW */
	public static final Set BLOCK_KEYWORDS =
		new HashSet(Arrays.asList(new String[]{"THEN", "ELSE"}));

	/** ݂̏ */
	private ReservedWordState state = ReservedWordState.INITIAL;

	/**
	 * RXgN^D
	 * @param name ʖ
	 * @throws Exception CX^XɎs
	 */
	public ReservedWordProcessor(String name) throws Exception {
		super(name);
	}
	/**
	 * ͋LԂɑ΂ė^
	 * ͂ꂽLɂāCԂJڂƂ^C~OŃCxg
	 * @param symbol ͋L
	 */
	protected void input(Symbol symbol) {
		if(state == ReservedWordState.FINISH || state == ReservedWordState.ERROR) {
			return;
		}
		CharacterSymbol cs = (CharacterSymbol)symbol;
		char c = Character.toUpperCase(cs.getCharacter());

		// ̗\ꂪ݂邩ǂ𒲂ׂ
		String candidate = sb.toString() + c;
		int rc = BuiltinCommandLibrary.getInstance().contains(candidate);

		// \ꂪR[hubN̊Jn^Iꂾꍇ
		if(BLOCK_KEYWORDS.contains(candidate)) {
			sb.append(c);
			tokenType = E_BLOCK;
			state = ReservedWordState.FINISH;
		// l̏ꍇ
		} else if(Character.isDigit(c)) {
			if(state == ReservedWordState.INITIAL) {
				// ԂłȂ萔ꍇ̓G[Ƃ
				state = ReservedWordState.ERROR;
			} else if(state == ReservedWordState.SCANNING_WORD && tokenType == E_RESERVED_WORD) {
				// \荞ݒɐꍇ͂ŏI
				state = ReservedWordState.FINISH;
				// l͍ĕ]̂ŁC|C^߂
				rollback();
			} else {
				// ȊO͒ǉ(ϐƂ)
				sb.append(c);
			}
		// At@xbg܂'$'܂'.'̏ꍇ(̏ꍇ'$'͕^ϐ̌^Cqł͂ȂC^֐̖)
		} else if(
			(state == ReservedWordState.SCANNING_WORD && c == '$') ||
			(state == ReservedWordState.SCANNING_WORD && c == '.') ||
			(c >= 'A' && c <= 'Z')
		) {
			switch(rc) {
				// \Ȃ
				case BuiltinCommandLibrary.SR_NONE:
					if(state == ReservedWordState.SCANNING_WORD && tokenType == E_RESERVED_WORD) {
						// ɗ\荞ݒ\ł邱Ƃm肵Ăꍇ͂ŏI
						state = ReservedWordState.FINISH;
						rollback();
					} else {
						if(c == '$' || c == '.') {
							rollback();
						} else {
							// ȊȌꍇC܂ł̓eϐ̈ꕔƂĊm肷
							vb.append(sb.toString());
		
							// XɁC͂ꂽ̂obt@ƂĎ荞
							// ӁF͂ꂽ̂ŗ\̍ĕ]Ȃ߁C1̗\͕KRIɉߕsƂȂ
							sb = new StringBuffer();
							sb.append(c);
						}
						state = ReservedWordState.SCANNING_VAR;
					}
					break;
				// ₠(OvŊY)
				case BuiltinCommandLibrary.SR_CANDIDATE:
					// ܂\̉\̂ŁC\荞ݏԂƂ
					state = ReservedWordState.SCANNING_WORD;
					sb.append(c);
					break;
				// \ꂠ
				case BuiltinCommandLibrary.SR_EXISTS:
					// ȂƂ\ł邱Ƃ킩̂ŁC\荞ݒƂ
					state = ReservedWordState.SCANNING_WORD;
					sb.append(c);
					tokenType = E_RESERVED_WORD;
					
					int functype = BuiltinCommandLibrary.getInstance().getFunctionTypeOf(candidate);
					int scptn = Lex.SCANNER_STD;
					switch(functype) {
						// f[^\󗝂ꍇCȍ~͑Săf[^\ƂĎ荞
						case Token.RTYPE_DAT:
							scptn = Lex.SCANNER_DATA;
							state = ReservedWordState.FINISH;
							break;
							
						// ߂󗝂ꍇCɎ荞݂𒆎~āCȍ~SăRgĎ荞
						case Token.RTYPE_RMK:
							scptn = Lex.SCANNER_REMARKS;
							state = ReservedWordState.FINISH;
							break;
					}
					// XLip^[̍đI
					setScannerPattern(scptn);
					break;
				// ̑(ʏ킠肦Ȃԋpl)
				default:
					// ̂ŃG[Ƃ
					state = ReservedWordState.ERROR;
			}
		} else {
			// ȊȌꍇ(^CȂ)
			if(state == ReservedWordState.INITIAL) {
				state = ReservedWordState.ERROR;
			} else if(state == ReservedWordState.SCANNING_WORD && tokenType == E_RESERVED_WORD) {
				rollback();
				state = ReservedWordState.FINISH;
			} else {
				switch(c) {
					case SyntaxConstant.C_VTYPE_SGL:	// Px
						state = valueType != Token.VTYPE_DEF ? ReservedWordState.ERROR : state;
						valueType = Token.VTYPE_SGL;
						break;
					case SyntaxConstant.C_VTYPE_DBL:	// {x
						state = valueType != Token.VTYPE_DEF ? ReservedWordState.ERROR : state;
						valueType = Token.VTYPE_DBL;
						break;
					case SyntaxConstant.C_VTYPE_INT:	// 
						state = valueType != Token.VTYPE_DEF ? ReservedWordState.ERROR : state;
						valueType = Token.VTYPE_INT;
						break;
					case SyntaxConstant.C_VTYPE_STR:	// 
						state = valueType != Token.VTYPE_DEF ? ReservedWordState.ERROR : state;
						valueType = Token.VTYPE_STR;
						break;
					case SyntaxConstant.C_BRACKET_LEFT: array = true;	// zϐ̓Y break
					default:
						state = ReservedWordState.FINISH;
						rollback();
				}
			}
		}
	}
	/**
	 * I
	 */
	public void finish() {
		if(state == ReservedWordState.ERROR) {
			setCausedException(new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1));
		}
	}
	/**
	 * ݂̏ԂIԂɂ邩ǂԂ
	 * @return true:I / false:p
	 */
	protected boolean isFiniteState() {
		return state == ReservedWordState.ERROR || state == ReservedWordState.FINISH;
	}
	/**
	 * ԑJڋ@BXLf[^ԂD
	 * \܂͕ϐ̃g[NԂD
	 * @return XLꂽf[^
	 */
	public Object getResult() {
		List results = new ArrayList();

		if(tokenType == E_VARIABLE) {
			// Ǘ\̎擾Ɏsꍇ́CPȂϐƂĊm肷
			vb.append(sb.toString());
			sb = new StringBuffer();
		}
		// ϐ
		if(StringUtils.isEmpty(vb.toString()) == false) {
			Token token = new Token(Token.TYPE_VARIABLE);
			token.setStrValue(vb.toString());
			token.setValueType(valueType);
			token.setVarType(array ? Token.VARTYPE_ARRAY : Token.VARTYPE_NORMAL);
			results.add(token);
		}

		// ̑
		if(StringUtils.isEmpty(sb.toString()) == false) {
			int type = 0;
			switch(tokenType) {
				case E_RESERVED_WORD:	type = Token.TYPE_RESERVED_WORD; break;
				case E_VARIABLE:		type = Token.TYPE_VARIABLE; break;
				case E_BLOCK:			type = Token.TYPE_BLOCK; break;
			}
			Token token = new Token(type);
			token.setStrValue(sb.toString());
			token.setValueType(valueType);
			token.setVarType(array ? Token.VARTYPE_ARRAY : Token.VARTYPE_NORMAL);
			if(tokenType == E_RESERVED_WORD) {
				// \̏ꍇC\^ݒ肷
				token.setFuncType(BuiltinCommandLibrary.getInstance().getFunctionTypeOf(token.getStrValue()));
			}
			results.add(token);
		}
		return (Token[])results.toArray(new Token[0]);
	}
}
