/*
 * $Id: StandardFileSystem.java,v 1.5 2008/11/12 18:01:05 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import org.logical_paradox.common.util.StringUtils;

/**
 * WIȃt@CVXeD
 * BASIC̃vO1t@CƂĕۑ^CvD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class StandardFileSystem extends PetitBasicFileSystem {
	/**
	 * RXgN^D
	 */
	public StandardFileSystem() {
		super();
	}
	/**
	 * wt@Cɑ΂o̓Xg[ԂD
	 * @param filename t@C
	 * @return o̓Xg[
	 * @throws FileNotFoundException Yt@CȂ
	 */
	protected OutputStream getOutputStream(String filename) throws FileNotFoundException {
		return new FileOutputStream(filename);
	}
	/**
	 * wt@Cɑ΂̓Xg[ԂD
	 * @param filename t@C
	 * @return ̓Xg[
	 * @throws FileNotFoundException Yt@CȂ
	 */
	protected InputStream getInputStream(String filename) throws FileNotFoundException {
		return new FileInputStream(filename);
	}
	/**
	 * wp^[ɍvt@C.
	 * @param filespec t@CXybN
	 * @return t@C̃Xg
	 */
	public String[] searchFileEntry(String filespec) {
		File[] files = findFiles(filespec);

		if(files == null || files.length == 0) {
			return new String[0];
		}

		String[] filename = new String[files.length];
		for(int i = 0; i < files.length; i++) {
			filename[i] = files[i].getName();
		}
		
		return filename;
	}
	/**
	 * wp^[ɍvt@C폜.
	 * @param filespec t@CXybN
	 * @return true:폜 / false:폜łȂ
	 * @throws FileNotFoundException 폜Ώۂ̃t@C݂Ȃ
	 */
	public boolean deleteFileEntry(String filespec) throws FileNotFoundException {
		File[] files = findFiles(filespec);
		
		if(files == null || files.length == 0) {
			throw new FileNotFoundException();
		}

		boolean success = true;
		for(int i = 0; i < files.length; i++) {
			success &= files[i].delete();
		}
		return success;
	}
	/**
	 * wp^[ɍvt@C𒊏o.
	 * @param filespec t@CXybN
	 * @return oꂽt@C
	 */
	protected File[] findFiles(String filespec) {
		String dirname = ".";
		String fs = "*";
		if(StringUtils.isEmpty(filespec) == false) {
			int slashpos = filespec.lastIndexOf(File.separator);
			if(slashpos >= 0) {
				dirname = filespec.substring(0, slashpos);
				fs = filespec.substring(slashpos);
			} else {
				fs = filespec;
			}
		}

		File file = new File(dirname);
		File[] files = file.listFiles(new PetitBasicFilenameFilter(fs));
		
		return files;
	}
}
