/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.util;

import java.util.ArrayList;

/**
 * ėp̕񃆁[eBeB
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class StringUtils {
	/**
	 * RXgN^
	 *
	 */
	private StringUtils() {
	}
	/**
	 * null܂͋󂩂ǂԂ
	 * @param msg ؑΏە
	 * @return true: / false:w肳Ă
	 */
	public static final boolean isEmpty(String msg) {
		return msg == null || msg.trim().length() == 0;
	}
	/**
	 * nullłȂCłȂǂԂ
	 * @param msg ؑΏە
	 * @return true:Ȃɂ̕ / false:null܂͋
	 */
	public static final boolean isNotEmpty(String msg) {
		return isEmpty(msg) == false;
	}
	/**
	 * 𕶎ɕϊ
	 * null^ꂽꍇC󕶎""ɕϊĕԂ
	 * @param str ϊΏۂ̕
	 * @return ϊꂽ(΂null߂ȂƂۏ؂Ă)
	 */
	public static final String toString(String str) {
		return str != null ? str : "";
	}
	/**
	 * 𑵂̌
	 * Ȃ'0'ŕ⊮
	 * @param num 
	 * @param cols 
	 * @return 0⊮ꂽ
	 */
	public static final String formatColumns(long num, int cols) {
		String n = "" + num;
		if(n.length() >= cols) {
			return n;
		}
		String base = sequence('0', cols -1) + n;
		if(base.length() == cols) {
			// 1̏ꍇ
			return base;
		} else {
			return base.substring(base.length() - cols);
		}
	}
	/**
	 * 񂪐ϊ\ǂԂ
	 * @param msg ؑΏە
	 * @return true:ϊ\ / false:ϊs\
	 */
	public static final boolean isIntStr(String msg) {
		boolean rc = true;
		try {
			Integer.parseInt(msg);
		} catch(NumberFormatException ne) {
			rc = false;
		}
		return rc;
	}
	/**
	 * 񂪑{ɕϊ\ǂԂ
	 * @param msg ؑΏە
	 * @return true:ϊ\ / false:ϊs\
	 */
	public static final boolean isLongStr(String msg) {
		boolean rc = true;
		try {
			Long.parseLong(msg);
		} catch(NumberFormatException ne) {
			rc = false;
		}
		return rc;
	}
	/**
	 * 񒆂Ɋ܂܂鐧LN^Sď
	 * @param str Ώۂ̕
	 * @return ꂽ
	 */
	public static final String trimControlChars(String str) {
		StringBuffer sb = new StringBuffer();
		char[] characters = str.toCharArray();
		
		for(int i = 0; i < characters.length; i++) {
			// ISOR[hȊȌꍇ͂̂܂ܒǉ
			if(characters[i] >= '\u0020') {
				sb.append(characters[i]);
			}
		}
		return sb.toString();
	}
	/**
	 * 󕶎񂾂̍sJbg
	 * @param lines s
	 * @return g~Oꂽs
	 */
	public static final String[] trimEmptyLines(String[] lines) {
		ArrayList l = new ArrayList();
		for(int i = 0; i < lines.length; i++) {
			if(isEmpty(lines[i]) == false) {
				l.add(lines[i]);
			}
		}

		return (String[])l.toArray(new String[0]);
	}
	/**
	 * w肳ꂽeLXgɑ݂P̏oʒuSĕԂ
	 * @param text Ώە
	 * @return 
	 */
	public static Integer[] searchWordIndexes(String text, String word) {
		ArrayList locations = new ArrayList();
		int bgn = 0;
		do {
			bgn = text.indexOf(word, bgn);
			if(bgn >= 0 && bgn < text.length()) {
				locations.add(new Integer(bgn));
				bgn++;
			}
		} while(bgn >= 0);

		return (Integer[])locations.toArray(new Integer[0]);
	}
	/**
	 * w肵ŕԂD
	 * w肵蒷ꍇ̓JbgD<br>
	 * w肵ZꍇCwhite spaceŖ߂D
	 * @param str 
	 * @param len 
	 * @return TCYꂽ
	 */
	public static final String resize(String str, int len) {
		if(len <= 0) {
			return "";
		}
		if(str.length() > len) {
			return str.substring(0, len);
		}
		return str + sequence(' ', len - str.length());
	}
	/**
	 * 𑵂̌
	 * Ȃ'0'ŕ⊮
	 * @param num 
	 * @param cols 
	 * @return 0⊮ꂽ
	 */
	public static final String formatColumns(int num, int cols) {
		String n = "" + num;
		if(n.length() >= cols) {
			return n;
		}
		String base = sequence('0', cols -1) + n;
		if(base.length() == cols) {
			// 1̏ꍇ
			return base;
		} else {
			return base.substring(base.length() - cols);
		}
	}
	/**
	 * w蕶wAԂ
	 * @param c ALN^
	 * @param count A
	 * @return ꂽ
	 */
	public static final String sequence(char c, int count) {
		StringBuffer sb = new StringBuffer();
		String cc = "" + c + c;
		for(; count > 1; count-=2) {
			sb.append(cc);
		}
		if(count % 2 == 1) {
			sb.append(c);
		}

		return sb.toString();
	}
	/**
	 * 񓯎mrD
	 * @param str1 rΏ1
	 * @param str2 rΏ2
	 * @return 0: / 1: str1 > str2 / -1: str1 < str2
	 */
	public static final int compare(String str1, String str2) {
		char[] char1 = str1.toCharArray();
		char[] char2 = str2.toCharArray();
		int loopCnt = char1.length > char2.length ? char2.length : char1.length;

		for(int i = 0; i < loopCnt; i++) {
			if(char1[i] == char2[i]) {
				// l̏ꍇ͎̕r
				continue;
			}
			return char1[i] > char2[i] ? 1 : -1;
		}

		// Sɓ̂ŁCŔr
		if(char1.length == char2.length) {
			// ܂ł
			return 0;
		}
		return char1.length > char2.length ? 1 : -1;
	}
	/**
	 * 64bit2itH[}bgɕϊD
	 * @param l ϊΏۂ̃O[h
	 * @return ϊꂽ(64Œ)
	 */
	public static final String format64bit(long l) {
		String bit64String = "0000000000000000000000000000000000000000000000000000000000000000" + Long.toBinaryString(l);
		return bit64String.substring(bit64String.length() - 64, bit64String.length());
	}

}
