/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.io;

import java.io.*;

/**
 * g\ȃoCgobt@
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version 1.0
 */
public class ExpandableBuffer implements ByteStream {
	public static final int DEFAULT_BLOCKSIZE = 4096;		// ftHg̃ubNTCY
	protected byte[] _buffer;									// obt@̎
	protected final int _blocksize;							// 1񂲂ƂɊgoCg
	protected int _eob;										// ݎgpĂobt@̍Ō̈ʒu
	protected int _seekp;										// ݂̃V[N|C^
	
	/**
	 * RXgN^D
	 * ftHg̃ubNTCYŏ
	 */
	public ExpandableBuffer() {
		this(DEFAULT_BLOCKSIZE);
	}
	/**
	 * RXgN^D
	 * w肳ꂽubNTCYŏ
	 * 
	 * @param blocksize ubNTCY(obt@gɎIɊmۂoCgTCY)
	 */
	public ExpandableBuffer(int blocksize) {
		_blocksize = blocksize;
		_buffer = new byte[blocksize];
		_eob = 0;
	}
	/**
	 * ݂̃obt@̃TCYԂ
	 * 
	 * @return TCY
	 */
	public int size() {
		return _buffer.length;
	}
	/**
	 * V[N|C^Đݒ肷
	 * 
	 * @param seekp V[N|C^
	 * @throws IOException V[N|C^obt@̏I[z
	 */
	public void seek(int seekp) throws IOException {
		_seekp = seekp;
	}
	/**
	 * obt@1oCgǂݍŕԂ<br>
	 * ǂݍ񂾏ꍇCV[N|C^1iށDǂݍރf[^݂Ȃꍇ-1Ԃ
	 * 
	 * @return ǂݍ񂾃oCgf[^(-1:f[^Ȃ)
	 * @throws IOException ͒ɉ炩̃G[
	 */
	public int read() throws IOException {
		synchronized(this) {
			if(_seekp >= _eob) {
				return -1;
			}
			int b = (int)_buffer[_seekp++] & 0xff;
			return b;
		}
	}
	/**
	 * oCgf[^݂̃V[N|C^̈ʒu֏
	 * @param i oCgf[^
	 * @throws IOException o͏ɉ炩̃G[ꍇ
	 */
	public void write(int i) throws IOException {
		synchronized(this) {
			if(_seekp >= size()) {
				// V[N|C^݂̃obt@̏I[zĂꍇ
				// obt@̍Ċg
				expand();
			}
			_buffer[_seekp++] = (byte)(i & 0xff);
			if(_seekp > _eob) {
				_eob = _seekp;
			}
		}
	}
	/**
	 * oCgf[^݂̃V[N|C^̈ʒu֏
	 * @param b oCgf[^
	 * @throws IOException o͏ɉ炩̃G[ꍇ
	 */
	public void write(byte b) throws IOException {
		write((int)b);
	}
	/**
	 * oCgf[^݂̃V[N|C^̈ʒu֏
	 * @param b oCgf[^
	 * @throws IOException o͏ɉ炩̃G[ꍇ
	 */
	public void write(byte[] b) throws IOException {
		for(int i = 0; i < b.length; i++) {
			write(b[i]);
		}
	}
	/**
	 * oCgf[^݂̃V[N|C^̈ʒu֏
	 * w肳ꂽoCgނA邢͑Sďo͂ꍇɏI
	 * @param b oCgf[^
	 * @param length ݒ
	 * @throws IOException o͏ɉ炩̃G[ꍇ
	 */
	public void write(byte[] b, int length) throws IOException {
		for(int i = 0; i < b.length && i < length; i++) {
			write(b[i]);
		}
	}
	/**
	 * ݃obt@ƂĎgpĂ̈̃TCYԂ
	 * 
	 * @return gpĂoCg
	 */
	public int using() {
		return _eob;
	}
	/**
	 * ̃obt@݂̌̏Ԃ𔽉f̓Xg[Ԃ
	 * 
	 * @return ̓Xg[
	 */
	public InputStream getInputStream() {
		return new ExpBufferInputStream(this);
	}
	/**
	 * ̃obt@݂̌̏Ԃ𔽉fo̓Xg[Ԃ
	 * 
	 * @return o̓Xg[
	 */
	public OutputStream getOutputStream() {
		return new ExpBufferOutputStream(this);
	}

	/**
	 * obt@g
	 */
	protected void expand() {
		synchronized(this) {
			int buffersize = size();
			byte[] newBuffer = new byte[buffersize + _blocksize];
			System.arraycopy(_buffer, 0, newBuffer, 0, buffersize);
			_buffer = newBuffer;
		}
	}
	/**
	 * ExpandableByteBuffer̓̓Xg[
	 * 
	 * @author satoshi akabane@logical-paradox.org
	 * @version 1.0
	 */
	protected class ExpBufferInputStream extends InputStream {
		protected ExpandableBuffer _buffer;
		protected ExpBufferInputStream(ExpandableBuffer buffer) {
			_buffer = buffer;
		}
		/**
		 * obt@1oCgǂݍŕԂ
		 * @return ǂݍ񂾃oCgf[^(-1:obt@̏I[)
		 * @exception IOException o͏ɉ炩̃G[ꍇ
		 */
		public int read() throws IOException {
			return _buffer.read();
		}
	}
	/**
	 * ExpandableByteBuffeȑo̓Xg[
	 * 
	 * @author satoshi akabane@logical-paradox.org
	 * @version 1.0
	 */
	protected class ExpBufferOutputStream extends OutputStream {
		protected ExpandableBuffer _buffer;
		protected ExpBufferOutputStream(ExpandableBuffer buffer) {
			_buffer = buffer;
		}

		/**
		 * oCgf[^o͂
		 * @param b oCgf[^
		 * @exception IOException o͏ɉ炩̃G[ꍇ
		 */
		public void write(int b) throws IOException {
			_buffer.write(b);
		}
	}
	/**
	 * ̃obt@̓eoCgɕϊĕԂ
	 * ƂƃoCgł͂邪D
	 * 
	 * @return obt@̓e(oCg)
	 */
	public byte[] byteStream() {
		byte[] buffer = new byte[_eob];
		System.arraycopy(_buffer, 0, buffer, 0, _eob);
		return buffer;
	}
}
