/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slalom;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelBase;
import pencilbox.slalom.Board;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private int gateLineWidth = 3;

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setNumberColor(Color.WHITE);
        this.setCircleColor(Color.BLACK);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.drawGrid(g);
        this.drawGates(g);
        this.drawLinks(g);
        this.drawNumbers(g);
        this.drawBoardBorder(g);
    }

    private void drawGates(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int state = this.board.getNumber(p);
            if (state >= 0) {
                this.placeNumber(g, p, this.board.getNGate());
            } else if (state == -4) {
                g.setColor(this.getGateColor());
                this.placeGateLine(g, p, 1);
            } else if (state == -5) {
                g.setColor(this.getGateColor());
                this.placeGateLine(g, p, 0);
            }
            ++n2;
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int state = this.board.getNumber(p);
            if (state >= 0) {
                g.setColor(this.getWallColor());
                this.paintCell(g, p);
                if (state > 0) {
                    g.setColor(this.getNumberColor());
                    this.placeNumber(g, p, state);
                }
            } else if (state == -1) {
                g.setColor(this.getBackgroundColor());
                this.placeFilledCircle(g, p, this.getCellSize() - 2);
                g.setColor(this.getCircleColor());
                this.placeCircle(g, p, this.getCellSize() - 2);
                this.placeNumber(g, p, this.board.getNGate());
            }
            ++n2;
        }
    }

    private void placeGateLine(Graphics2D g, Address p, int dir) {
        if (dir == 1) {
            this.drawLineSegment(g, this.toX(p), this.toY(p) + this.getHalfCellSize(), dir, this.gateLineWidth);
        } else if (dir == 0) {
            this.drawLineSegment(g, this.toX(p) + this.getHalfCellSize(), this.toY(p), dir, this.gateLineWidth);
        }
    }

    private void drawLinks(Graphics2D g) {
        SideAddress[] sideAddressArray = this.board.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            int state = this.board.getState(p);
            if (state == 1) {
                g.setColor(this.getLineColor());
                if (this.isSeparateLinkColorMode()) {
                    g.setColor(Colors.getColor(this.board.getLink(p).getId()));
                }
                this.placeLink(g, p);
            } else if (state == -1) {
                g.setColor(this.getCrossColor());
                this.placeSideCross(g, p);
            }
            ++n2;
        }
    }
}

