/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.goishi;

import java.util.ArrayList;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.resource.Messages;

public class Board
extends BoardBase {
    static final int BLANK = 0;
    static final int STONE = -1;
    private int[][] state;
    private int[][] number;
    ArrayList<Address> pickedList;

    @Override
    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.number = new int[this.rows()][this.cols()];
        this.pickedList = new ArrayList();
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getState(p) == -1) {
                this.setNumber(p, 0);
            }
            ++n2;
        }
        this.pickedList.clear();
    }

    public boolean isStone(Address pos) {
        return this.getState(pos) == -1;
    }

    public int getState(int r, int c) {
        if (!this.isOn(r, c)) {
            return 0;
        }
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        if (!this.isOn(r, c)) {
            return;
        }
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public int getNumber(Address pos) {
        return this.number[pos.r()][pos.c()];
    }

    public void setNumber(Address pos, int n) {
        this.number[pos.r()][pos.c()] = n;
    }

    @Override
    public void initBoard() {
    }

    public void changeState(Address p, int st) {
        int m;
        int prev = this.getState(p);
        if (prev == st) {
            return;
        }
        if (st == -1) {
            int m2 = this.checkRoute(p);
            if (m2 > 0) {
                this.placeBackFromN(m2);
            }
        } else if (st == 0 && (m = this.getNumber(p)) > 0) {
            this.placeBackFromN(m);
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.FIXED, p, this.getState(p), st));
        }
        this.setState(p, st);
    }

    private void placeBackFromN(int m) {
        int i = this.pickedList.size();
        while (i >= m) {
            this.placeBack();
            --i;
        }
    }

    public void pickUp(Address p) {
        int n = this.pickedList.size();
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.STATE, p, 0, n + 1));
        }
        this.pickedList.add(p);
        this.setNumber(p, n + 1);
    }

    public void placeBack() {
        int n = this.pickedList.size();
        Address p = this.pickedList.get(n - 1);
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.STATE, p, n, 0));
        }
        this.pickedList.remove(n - 1);
        this.setNumber(p, 0);
    }

    public boolean canPick(Address pos) {
        if (this.getState(pos) != -1) {
            return false;
        }
        if (this.getNumber(pos) > 0) {
            return false;
        }
        if (this.pickedList.size() == 0) {
            return true;
        }
        Address prev = this.pickedList.get(this.pickedList.size() - 1);
        int direction = Address.getDirectionTo(prev, pos);
        if (direction < 0) {
            return false;
        }
        Address p = prev;
        while (!p.equals(pos)) {
            if (this.isStone(p) && this.getNumber(p) == 0) {
                return false;
            }
            p = p.nextCell(direction);
        }
        if (this.pickedList.size() == 1) {
            return true;
        }
        Address prev2 = this.pickedList.get(this.pickedList.size() - 2);
        int direction2 = Address.getDirectionTo(prev, prev2);
        return direction != direction2;
    }

    private int checkRoute(Address p0) {
        int[] next4 = new int[4];
        int d = 0;
        while (d < 4) {
            Address p = p0;
            while (this.isOn(p)) {
                if (this.getState(p = p.nextCell(d)) != -1) continue;
                int n = this.getNumber(p);
                if (n <= 0) break;
                next4[d] = n;
                break;
            }
            ++d;
        }
        int m1 = this.diff1(next4[0], next4[2]);
        int m2 = this.diff1(next4[1], next4[3]);
        int mm = this.min2(m1, m2);
        return mm;
    }

    private int diff1(int a, int b) {
        if (a > 0 && b > 0) {
            if (a == b + 1) {
                return a;
            }
            if (b == a + 1) {
                return b;
            }
        }
        return 0;
    }

    private int min2(int a, int b) {
        if (a > 0 && b > 0) {
            return a > b ? b : a;
        }
        if (a > 0 && b == 0) {
            return a;
        }
        if (b > 0 && a == 0) {
            return b;
        }
        return 0;
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (step.getType() == AbstractStep.EditType.FIXED) {
                this.changeState(s.getPos(), s.getBefore());
            } else if (step.getType() == AbstractStep.EditType.STATE) {
                if (s.getBefore() > 0) {
                    this.pickUp(s.getPos());
                } else {
                    this.placeBack();
                }
            }
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (step.getType() == AbstractStep.EditType.FIXED) {
                this.changeState(s.getPos(), s.getAfter());
            } else if (step.getType() == AbstractStep.EditType.STATE) {
                if (s.getAfter() > 0) {
                    this.pickUp(s.getPos());
                } else {
                    this.placeBack();
                }
            }
        }
    }

    @Override
    public int checkAnswerCode() {
        int nStone = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getState(p) == -1) {
                ++nStone;
                if (this.getNumber(p) == 0) {
                    return 1;
                }
            }
            ++n2;
        }
        if (nStone == 0) {
            return 2;
        }
        return 0;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        if (result == 2) {
            return Messages.getString("goishi.AnswerCheckMessage2");
        }
        if (result == 1) {
            return Messages.getString("goishi.AnswerCheckMessage1");
        }
        return "";
    }
}

