/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.core.SideAddress;

public abstract class PzprReaderBase {
    private BoardBase bd;
    private String pflag = "";
    protected int cols;
    protected int rows;
    protected String outbstr = "";
    protected int[] roomNumbers;
    protected int[] borders;
    protected int[] areaIds;
    protected int nArea;

    public BoardBase readProblem(String url) throws IOException, PencilBoxException {
        this.parseURI_pzpr(url.substring(url.indexOf(47, url.indexOf(63)) + 1));
        if (this.rows <= 0 || this.cols <= 0) {
            throw new PencilBoxException("Size data is wrong");
        }
        this.bd = this.makeBoard();
        this.pzlimport();
        return this.bd;
    }

    protected void parseURI_pzpr(String qstr) throws PencilBoxException {
        String[] inpa = qstr.split("/");
        LinkedList<String> inp = new LinkedList<String>(Arrays.asList(inpa));
        if (inp.getFirst().length() > 0 && !PzprReaderBase.include(inp.getFirst().charAt(0), '0', '9')) {
            this.pflag = inp.removeFirst();
        }
        if (inpa.length < 2) {
            throw new PencilBoxException("Size data is required.");
        }
        this.cols = PzprReaderBase.parseInt(inp.removeFirst());
        this.rows = PzprReaderBase.parseInt(inp.removeFirst());
        StringBuffer sb = new StringBuffer();
        for (String s : inp) {
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append(s);
        }
        this.outbstr = sb.toString();
    }

    protected BoardBase makeBoard() {
        return null;
    }

    protected void pzlimport() {
    }

    protected void outbstr(String bstr, int i) {
        this.outbstr = i >= bstr.length() ? "" : bstr.substring(i);
    }

    protected boolean checkpflag(String ca) {
        return this.pflag.indexOf(ca) >= 0;
    }

    protected void decode4Cell() {
        int c = 0;
        int i = 0;
        String bstr = this.outbstr;
        i = 0;
        while (i < bstr.length()) {
            char ca = bstr.charAt(i);
            if (PzprReaderBase.include(ca, '0', '4')) {
                this.sQnC(c, PzprReaderBase.parseInt(ca, 16));
                ++c;
            } else if (PzprReaderBase.include(ca, '5', '9')) {
                this.sQnC(c, PzprReaderBase.parseInt(ca, 16) - 5);
                c += 2;
            } else if (PzprReaderBase.include(ca, 'a', 'e')) {
                this.sQnC(c, PzprReaderBase.parseInt(ca, 16) - 10);
                c += 3;
            } else if (PzprReaderBase.include(ca, 'g', 'z')) {
                c += PzprReaderBase.parseInt(ca, 36) - 15;
            } else if (ca == '.') {
                this.sQnC(c, -2);
                ++c;
            }
            if (c >= this.rows * this.cols) break;
            ++i;
        }
        this.outbstr(bstr, i + 1);
    }

    protected void decodeNumber16() {
        int c = 0;
        int i = 0;
        String bstr = this.outbstr;
        i = 0;
        while (i < bstr.length()) {
            char ca = bstr.charAt(i);
            if (PzprReaderBase.include(ca, '0', '9') || PzprReaderBase.include(ca, 'a', 'f')) {
                this.sQnC(c, PzprReaderBase.parseInt(bstr.substring(i, i + 1), 16));
                ++c;
            } else if (ca == '.') {
                this.sQnC(c, -2);
                ++c;
            } else if (ca == '-') {
                this.sQnC(c, PzprReaderBase.parseInt(bstr.substring(i + 1, i + 3), 16));
                ++c;
                i += 2;
            } else if (ca == '+') {
                this.sQnC(c, PzprReaderBase.parseInt(bstr.substring(i + 1, i + 4), 16));
                ++c;
                i += 3;
            } else if (ca == '=') {
                this.sQnC(c, PzprReaderBase.parseInt(bstr.substring(i + 1, i + 4), 16) + 4096);
                ++c;
                i += 3;
            } else if (ca == '%') {
                this.sQnC(c, PzprReaderBase.parseInt(bstr.substring(i + 1, i + 4), 16) + 8192);
                ++c;
                i += 3;
            } else {
                c = ca >= 'g' && ca <= 'z' ? (c += PzprReaderBase.parseInt(ca, 36) - 15) : ++c;
            }
            if (c > this.rows * this.cols) break;
            ++i;
        }
        this.outbstr(bstr, i);
    }

    protected void decodeRoomNumber16() {
        int r = 0;
        int i = 0;
        String bstr = this.outbstr;
        i = 0;
        while (i < bstr.length()) {
            char ca = bstr.charAt(i);
            if (PzprReaderBase.include(ca, '0', '9') || PzprReaderBase.include(ca, 'a', 'f')) {
                this.roomNumbers[r] = PzprReaderBase.parseInt(bstr.substring(i, i + 1), 16);
                ++r;
            } else if (ca == '-') {
                this.roomNumbers[r] = PzprReaderBase.parseInt(bstr.substring(i + 1, i + 2), 16);
                ++r;
                i += 2;
            } else if (ca == '+') {
                this.roomNumbers[r] = PzprReaderBase.parseInt(bstr.substring(i + 1, i + 3), 16);
                ++r;
                i += 3;
            } else if (ca == '=') {
                this.roomNumbers[r] = PzprReaderBase.parseInt(bstr.substring(i + 1, i + 3), 16) + 4096;
                ++r;
                i += 3;
            } else if (ca == '%') {
                this.roomNumbers[r] = PzprReaderBase.parseInt(bstr.substring(i + 1, i + 3), 16) + 8192;
                ++r;
                i += 3;
            } else if (ca == '*') {
                this.roomNumbers[r] = PzprReaderBase.parseInt(bstr.substring(i + 1, i + 3), 16) + 12240;
                ++r;
                i += 4;
            } else if (ca == '$') {
                this.roomNumbers[r] = PzprReaderBase.parseInt(bstr.substring(i + 1, i + 3), 16) + 77776;
                ++r;
                i += 5;
            } else {
                r = ca >= 'g' && ca <= 'z' ? (r += PzprReaderBase.parseInt(ca, 36) - 15) : ++r;
            }
            if (r >= this.roomNumbers.length) break;
            ++i;
        }
        this.outbstr(bstr, i);
    }

    protected void decodeArrowNumber16() {
        int c = 0;
        int i = 0;
        String bstr = this.outbstr;
        i = 0;
        while (i < bstr.length()) {
            char ca = bstr.charAt(i);
            if (ca == '0') {
                if (bstr.charAt(i + 1) == '.') {
                    this.sQnC(c, -2);
                    ++c;
                    ++i;
                } else {
                    this.sQnC(c, PzprReaderBase.parseInt(bstr.substring(i + 1, i + 2), 16));
                    ++c;
                    ++i;
                }
            } else if (ca == '5') {
                this.sQnC(c, PzprReaderBase.parseInt(bstr.substring(i + 1, i + 3), 16));
                ++c;
                i += 2;
            } else if (PzprReaderBase.include(ca, '1', '4')) {
                this.sDiC(c, PzprReaderBase.parseInt(ca, 16));
                if (bstr.charAt(i + 1) != '.') {
                    this.sQnC(c, PzprReaderBase.parseInt(bstr.substring(i + 1, i + 2), 16));
                } else {
                    this.sQnC(c, -2);
                }
                ++c;
                ++i;
            } else if (PzprReaderBase.include(ca, '6', '9')) {
                this.sDiC(c, PzprReaderBase.parseInt(ca, 16) - 5);
                this.sQnC(c, PzprReaderBase.parseInt(bstr.substring(i + 1, i + 3), 16));
                ++c;
                i += 2;
            } else {
                c = ca >= 'a' && ca <= 'z' ? (c += PzprReaderBase.parseInt(ca, 36) - 9) : ++c;
            }
            if (c > this.rows * this.cols) break;
            ++i;
        }
        this.outbstr(bstr, i);
    }

    protected void decodeBorder() {
        int pos2;
        int pos1;
        int bdinside = (this.cols - 1) * this.rows + this.cols * (this.rows - 1);
        this.borders = new int[bdinside];
        String bstr = this.outbstr;
        if (bstr.length() > 0) {
            pos1 = Math.min(PzprReaderBase.mf(((this.cols - 1) * this.rows + 4) / 5), bstr.length());
            pos2 = Math.min(PzprReaderBase.mf((this.cols * (this.rows - 1) + 4) / 5) + pos1, bstr.length());
        } else {
            pos1 = 0;
            pos2 = 0;
        }
        int i = 0;
        while (i < pos1) {
            int ca = PzprReaderBase.parseInt(bstr.charAt(i), 32);
            int w = 0;
            while (w < 5) {
                if (i * 5 + w < (this.cols - 1) * this.rows) {
                    this.sQuB(i * 5 + w, (ca & 1 << 4 - w) > 0 ? 1 : 0);
                }
                ++w;
            }
            ++i;
        }
        int oft = (this.cols - 1) * this.rows;
        int i2 = 0;
        while (i2 < pos2 - pos1) {
            int ca = PzprReaderBase.parseInt(bstr.charAt(i2 + pos1), 32);
            int w = 0;
            while (w < 5) {
                if (i2 * 5 + w < this.cols * (this.rows - 1)) {
                    this.sQuB(i2 * 5 + w + oft, (ca & 1 << 4 - w) > 0 ? 1 : 0);
                }
                ++w;
            }
            ++i2;
        }
        this.outbstr(bstr, pos2);
    }

    protected void makeAreaIDsFromBorders() {
        this.areaIds = new int[this.rows * this.cols];
        int i = 0;
        while (i < this.rows * this.cols) {
            if (this.areaIds[i] == 0) {
                ++this.nArea;
                this.visit(this.i2a(i), this.nArea);
            }
            ++i;
        }
    }

    private void visit(Address a, int n) {
        if (this.areaIds[this.a2i(a)] == n) {
            return;
        }
        this.areaIds[this.a2i((Address)a)] = n;
        int d = 0;
        while (d < 4) {
            Address aa = Address.nextCell(a, d);
            SideAddress bb = SideAddress.get(a, d);
            if (this.isOn(aa) && this.borders[this.b2i(bb)] == 0) {
                this.visit(aa, n);
            }
            ++d;
        }
    }

    protected void decodeCircle41_42() {
        String bstr = this.outbstr;
        int pos = bstr.length() > 0 ? Math.min(PzprReaderBase.mf((this.cols * this.rows + 2) / 3), bstr.length()) : 0;
        int i = 0;
        while (i < pos) {
            int ca = PzprReaderBase.parseInt(bstr.charAt(i), 27);
            int w = 0;
            while (w < 3) {
                if (i * 3 + w < this.cols * this.rows) {
                    if (Math.floor((double)ca / Math.pow(3.0, 2 - w)) % 3.0 == 1.0) {
                        this.sQuC(i * 3 + w, 41);
                    } else if (Math.floor((double)ca / Math.pow(3.0, 2 - w)) % 3.0 == 2.0) {
                        this.sQuC(i * 3 + w, 42);
                    }
                }
                ++w;
            }
            ++i;
        }
        this.outbstr(bstr, pos);
    }

    public boolean isOn(Address a) {
        int r = a.r();
        int c = a.c();
        return r >= 0 && r < this.rows && c >= 0 && c < this.cols;
    }

    public Address i2a(int i) {
        return Address.address(i / this.cols, i % this.cols);
    }

    public int a2i(Address a) {
        return a.r() * this.cols + a.c();
    }

    public int b2i(SideAddress b) {
        if (b.d() == 0) {
            return b.r() * (this.cols - 1) + b.c();
        }
        if (b.d() == 1) {
            return this.rows * (this.cols - 1) + b.r() * this.cols + b.c();
        }
        return -1;
    }

    protected void sQuC(int id, int num) {
    }

    protected void sQnC(int id, int num) {
    }

    protected void sDiC(int id, int num) {
    }

    protected void sQuB(int id, int num) {
        this.borders[id] = num;
    }

    public static final int mf(int i) {
        return i;
    }

    public static final boolean include(char ca, char bottom, char up) {
        return bottom <= ca && ca <= up;
    }

    public static final int parseInt(char c, int radix) {
        return Integer.parseInt(new String(new char[]{c}), radix);
    }

    public static final int parseInt(String s, int radix) {
        return Integer.parseInt(s, radix);
    }

    public static final int parseInt(String s) {
        return Integer.parseInt(s);
    }
}

