/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.core.Problem;
import pencilbox.common.core.Size;
import pencilbox.common.core.UndoManager;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilFactory;
import pencilbox.common.factory.PencilType;
import pencilbox.common.gui.CellSizeDialog;
import pencilbox.common.gui.DataExportDialog;
import pencilbox.common.gui.EventHandlerManager;
import pencilbox.common.gui.ExchangeNumbersDialog;
import pencilbox.common.gui.FileChooser;
import pencilbox.common.gui.Frame;
import pencilbox.common.gui.HistoryDialog;
import pencilbox.common.gui.IndexLettersDialog;
import pencilbox.common.gui.LinkWidthDialog;
import pencilbox.common.gui.NewBoardDialog;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PanelImageTransfer;
import pencilbox.common.gui.PanelImageWriter;
import pencilbox.common.gui.PreferencesCopierBase;
import pencilbox.common.gui.PrintPreviewDialog;
import pencilbox.common.gui.PropertyDialog;
import pencilbox.common.gui.RotateBoardDialog;
import pencilbox.common.io.IOController;
import pencilbox.resource.Messages;
import pencilbox.sudoku.Board;
import pencilbox.util.Colors;

public class MenuCommand {
    private PencilType pencilType;
    private Frame frame;
    private PanelBase panel;
    private EventHandlerManager handler;
    private Problem problem;
    private BoardBase board;
    private Timer playBackTimer;

    public void setup(PencilType puzzleType, Frame frame, PanelBase panel, EventHandlerManager handler, Problem problem) {
        this.pencilType = puzzleType;
        this.frame = frame;
        this.panel = panel;
        this.handler = handler;
        this.problem = problem;
        this.board = problem.getBoard();
        this.setFrameTitle();
        if (this.board.getUndoManager() == null) {
            this.board.setUndoManager(new UndoManager(this.board));
        }
        this.board.initBoard();
    }

    public void setup(PencilType puzzleType, Problem problem) {
        this.setup(puzzleType, this.frame, this.panel, this.handler, problem);
    }

    public PanelBase getPanelBase() {
        return this.panel;
    }

    public EventHandlerManager getEventHandlerManager() {
        return this.handler;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Problem getProblem() {
        return this.problem;
    }

    private UndoManager getUndoManager() {
        return this.board.getUndoManager();
    }

    private void setFrameTitle() {
        this.frame.setTitle(String.valueOf(this.problem.getFileName()) + " - " + "PencilBox");
    }

    public void showErrorMessage(Exception e) {
        JOptionPane.showMessageDialog(this.frame, e.getMessage(), Messages.getString("MenuCommand.Message_Error"), 0);
    }

    public void showErrorMessage(String s) {
        JOptionPane.showMessageDialog(this.frame, s, Messages.getString("MenuCommand.Message_Error"), 0);
    }

    public void newBoard() {
        try {
            Size newSize;
            NewBoardDialog newBoardDialog = NewBoardDialog.getInstance();
            newBoardDialog.setCurrentSize(this.board.getSize());
            if (newBoardDialog.showDialog(this.frame, Messages.getString("MenuCommand.newBoardDialog")) == 0 && (newSize = newBoardDialog.getNewSize()) != null && this.isValidSize(newSize)) {
                PencilFactory.getInstance(this.pencilType, this).createNewFrame(newSize);
            }
        }
        catch (PencilBoxClassException e) {
            this.showErrorMessage(e);
        }
    }

    private boolean isValidSize(Size s) {
        int rows = s.getRows();
        int cols = s.getCols();
        if (rows < 0 || cols < 0) {
            this.showErrorMessage(Messages.getString("MenuCommand.Message_InappropriateSize"));
            return false;
        }
        if (rows > 200 || cols > 200) {
            this.showErrorMessage(Messages.getString("MenuCommand.Message_TooLarge"));
            return false;
        }
        if (this.pencilType == PencilType.SUDOKU) {
            if (rows == cols) {
                int n = 1;
                while (n < 10) {
                    if (rows == n * n) {
                        return true;
                    }
                    ++n;
                }
            }
            this.showErrorMessage(Messages.getString("MenuCommand.Message_InappropriateSize"));
            return false;
        }
        return true;
    }

    private FileChooser prepareFileChooser() {
        FileChooser fileChooser = FileChooser.getProblemFileChooser();
        File currentFile = this.problem.getFile();
        if (currentFile != null) {
            fileChooser.setSelectedFile(currentFile);
        }
        return fileChooser;
    }

    public void open() {
        FileChooser fileChooser = this.prepareFileChooser();
        try {
            if (fileChooser.showOpenDialog(this.frame) == 0) {
                File file = fileChooser.getSelectedFile();
                PencilFactory.getInstance(this.pencilType, this).createNewFrame(file);
            }
        }
        catch (PencilBoxException e) {
            this.showErrorMessage(e);
        }
    }

    public void closeAndOpen() {
        FileChooser fileChooser = this.prepareFileChooser();
        try {
            if (fileChooser.showOpenDialog(this.frame) == 0) {
                File file = fileChooser.getSelectedFile();
                PencilFactory.getInstance(this.pencilType, this).createNewBoard(file);
            }
        }
        catch (PencilBoxException e) {
            this.showErrorMessage(e);
        }
    }

    public void save() {
        FileChooser fileChooser = this.prepareFileChooser();
        try {
            if (fileChooser.showSaveDialog(this.frame) == 0) {
                File file = fileChooser.getSelectedFile();
                IOController.getInstance(this.pencilType).saveFile(this.problem, file);
            }
        }
        catch (PencilBoxException e) {
            this.showErrorMessage(e);
        }
        this.setFrameTitle();
    }

    public void duplicate() {
        try {
            PencilFactory.getInstance(this.pencilType, this).duplicateFrame();
        }
        catch (PencilBoxClassException e) {
            this.showErrorMessage(e);
        }
    }

    public void rotateBoard() {
        try {
            int n;
            RotateBoardDialog dialog = RotateBoardDialog.getInstance();
            if (dialog.showDialog(this.frame, Messages.getString("MenuCommand.rotateBoardDialog")) == 0 && (n = dialog.getSelection()) >= 1 && n <= 7) {
                PencilFactory.getInstance(this.pencilType, this).rotateBoard(n);
            }
        }
        catch (PencilBoxClassException e) {
            this.showErrorMessage(e);
        }
    }

    public void rotateBoard(int n) {
        try {
            PencilFactory.getInstance(this.pencilType, this).rotateBoard(n);
        }
        catch (PencilBoxClassException e) {
            this.showErrorMessage(e);
        }
    }

    public void changeBoardSize() {
        try {
            Size newSize;
            NewBoardDialog newBoardDialog = NewBoardDialog.getInstance();
            newBoardDialog.setCurrentSize(this.board.getSize());
            if (newBoardDialog.showDialog(this.frame, Messages.getString("MenuCommand.changeBoardSizeDialog")) == 0 && (newSize = newBoardDialog.getNewSize()) != null && this.isValidSize(newSize)) {
                PencilFactory.getInstance(this.pencilType, this).changeBoardSize(newSize);
            }
        }
        catch (PencilBoxClassException e) {
            this.showErrorMessage(e);
        }
    }

    public void printPreview() {
        PrintPreviewDialog d = PrintPreviewDialog.getInstance();
        d.setPrintObject(this.panel);
        d.showDialog(this.frame);
    }

    public void print() {
        PrintPreviewDialog d = PrintPreviewDialog.getInstance();
        d.setPrintObject(this.panel);
        d.print();
    }

    public void exportProblemData(IOController.DataFormat f) {
        DataExportDialog dataExportFrame = new DataExportDialog();
        try {
            IOController io = IOController.getInstance(this.pencilType);
            String url = io.exportProblemData(this.board, f);
            dataExportFrame.setText(url);
            int ret = dataExportFrame.showDialog(this.frame, Messages.getString("MenuCommand.dataExportDialog"));
            if (ret == 0) {
                String s = dataExportFrame.getText();
                Problem problem = io.importProblemData(s, f);
                PencilFactory.getInstance(this.pencilType, this).createNewFrame(problem);
            }
        }
        catch (PencilBoxException e) {
            e.printStackTrace();
        }
    }

    public void saveImage() {
        FileChooser chooser = FileChooser.getImageFileChooser();
        if (chooser.showSaveDialog(this.frame) == 0) {
            File file = chooser.getSelectedFile();
            new PanelImageWriter().saveImageToFile(this.panel, file);
        }
    }

    public void copyImage() {
        new PanelImageTransfer().copyImage(this.panel);
    }

    public void property() {
        PropertyDialog propertyDialog = PropertyDialog.getInstance();
        propertyDialog.setPropertyToDialog(this.problem.getProperty());
        if (propertyDialog.showDialog(this.frame, Messages.getString("MenuCommand.properyDialog")) == 0) {
            propertyDialog.getPropertyFromDialog(this.problem.getProperty());
        }
    }

    public void loadPreferences() {
        PreferencesCopierBase copier = PreferencesCopierBase.createInstance(this.pencilType);
        FileChooser fileChooser = FileChooser.getPreferenceFileChooser();
        if (fileChooser.showOpenDialog(this.frame) == 0) {
            File file = fileChooser.getSelectedFile();
            copier.loadPreferences(this, file);
            this.frame.resize();
        }
    }

    public void storePreferences() {
        PreferencesCopierBase copier = PreferencesCopierBase.createInstance(this.pencilType);
        FileChooser fileChooser = FileChooser.getPreferenceFileChooser();
        if (fileChooser.showSaveDialog(this.frame) == 0) {
            File file = fileChooser.getSelectedFile();
            copier.storePreferences(this, file);
        }
    }

    public void close() {
        this.frame.dispose();
    }

    public void quit() {
        System.exit(0);
    }

    public void about() {
        JOptionPane.showMessageDialog(this.frame, this.getAboutText(), Messages.getString("MenuCommand.aboutDialog"), 1);
    }

    private String getAboutText() {
        return "PencilBox version 1.6.1\nCopyright (c) 2006-2011 Nayuta\nhttp://pencilbox.sourceforge.jp/\n";
    }

    public void clear() {
        this.getUndoManager().discardAllEdits();
        this.board.clearBoard();
        this.handler.resetImmediateAnswerCheckMode();
        this.panel.repaint();
    }

    public void trimAnswer() {
        this.board.trimAnswer1();
        this.panel.repaint();
    }

    public void setSymmetricPlacementMode(boolean b) {
        this.handler.setSymmetricPlacementMode(b);
    }

    public void checkAnswer() {
        JOptionPane.showMessageDialog(this.frame, this.board.checkAnswerString(), Messages.getString("MenuCommand.checkAnswerDialog"), 1);
    }

    public void setImmediateAnswerCheckMode(boolean b) {
        this.handler.setImmediateAnswerCheckMode(b);
        if (b) {
            this.handler.checkAnswer();
        }
    }

    public void undo() {
        if (this.getUndoManager().canUndo()) {
            this.getUndoManager().undo();
        }
    }

    public void redo() {
        if (this.getUndoManager().canRedo()) {
            this.getUndoManager().redo();
        }
    }

    public void undoAll() {
        while (this.getUndoManager().canUndo()) {
            this.getUndoManager().undo();
        }
    }

    public void redoAll() {
        while (this.getUndoManager().canRedo()) {
            this.getUndoManager().redo();
        }
    }

    public void playback() {
        this.undoAll();
        if (this.playBackTimer == null) {
            this.makePlayBackTimer();
        }
        this.playBackTimer.start();
    }

    private void makePlayBackTimer() {
        this.playBackTimer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (MenuCommand.this.getUndoManager().canRedo()) {
                    MenuCommand.this.getUndoManager().redo();
                    MenuCommand.this.panel.repaint();
                } else {
                    MenuCommand.this.playBackTimer.stop();
                }
            }
        });
    }

    public void history() {
        HistoryDialog historyDialog = HistoryDialog.getInstance();
        historyDialog.init(this.getPanelBase(), this.getUndoManager());
        int k = this.getUndoManager().getIndexOfNextAdd();
        int ret = historyDialog.showDialog(this.frame, Messages.getString("MenuCommand.historyDialog"));
        if (ret != 0 && (ret == 2 || ret == -1)) {
            this.getUndoManager().jumpTo(k);
            this.panel.repaint();
        }
    }

    public boolean canUndo() {
        return this.getUndoManager().canUndo();
    }

    public boolean canRedo() {
        return this.getUndoManager().canRedo();
    }

    public void setEditMode(int mode) {
        if (this.panel.getEditMode() == mode) {
            return;
        }
        this.handler.setEditMode(mode);
        this.board.initBoard();
    }

    public void exchangeNumbers() {
        ExchangeNumbersDialog dialog = ExchangeNumbersDialog.getInstance();
        dialog.setup(this.board, this.panel);
        if (this.pencilType == PencilType.SUDOKU) {
            dialog.setRange(1, ((Board)this.board).getMaxNumber());
        }
        dialog.showDialog(this.frame, Messages.getString("ExchangeNumbersDialog.title"));
    }

    public void setCursorMode(boolean b) {
        this.panel.setCursorMode(b);
    }

    public void cellSize() {
        int currentCellSize = this.getPanelBase().getCellSize();
        CellSizeDialog cellSizeDialog = CellSizeDialog.getInstance();
        cellSizeDialog.setPanel(this.getPanelBase());
        cellSizeDialog.setCellSize(currentCellSize);
        int result = cellSizeDialog.showDialog(this.frame, Messages.getString("MenuCommand.cellSizeDialog"));
        int newCellSize = cellSizeDialog.getCellSize();
        if (result == 0) {
            this.getPanelBase().setDisplaySize(newCellSize);
            this.getFrame().resize();
        } else if ((result == 2 || result == -1) && currentCellSize != newCellSize) {
            this.getPanelBase().setDisplaySize(currentCellSize);
            this.getFrame().resize();
        }
    }

    public void setIndexMode(boolean b) {
        this.panel.changeIndexMode(b);
        this.frame.resize();
    }

    public void selectIndexLetters() {
        boolean currentValue = this.getPanelBase().isIndexMode();
        IndexLettersDialog indexLettersDialog = IndexLettersDialog.getInstance();
        indexLettersDialog.setPanel(this.getPanelBase());
        int result = indexLettersDialog.showDialog(this.frame, Messages.getString("MenuCommand.indexLettersDialog"));
        if (result == 0 && this.getPanelBase().isIndexMode() != currentValue) {
            this.getFrame().resize();
        }
    }

    public void setGridStyle(boolean b) {
        this.panel.setGridStyle(b ? 1 : 0);
    }

    public void renewColor() {
        Colors.randomize();
        this.panel.repaint();
    }

    public void changeLinkWidth() {
        int currentValue = this.getPanelBase().getLinkWidth();
        LinkWidthDialog dialog = LinkWidthDialog.getInstance();
        dialog.setPanel(this.getPanelBase());
        dialog.init();
        dialog.setValue(this.getPanelBase().getLinkWidth());
        int result = dialog.showDialog(this.frame, Messages.getString("MenuCommand.linkWidthDialog"));
        int value = dialog.getValue();
        if (result == 0) {
            this.getPanelBase().setLinkWidth(value);
        } else if ((result == 2 || result == -1) && currentValue != value) {
            this.getPanelBase().setLinkWidth(currentValue);
            this.getFrame().resize();
        }
    }
}

