/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import pencilbox.common.core.Address;
import pencilbox.common.core.Size;

public class SideAddress
implements Comparable<SideAddress> {
    private static int MAX = -2;
    private static SideAddress[][][] ADDRESS;
    public static final SideAddress NOWHERE;
    private final int d;
    private final int r;
    private final int c;

    static {
        SideAddress.createSideAddressInstances(11);
        NOWHERE = SideAddress.sideAddress(-1, -1, -1);
    }

    public static void createSideAddressInstances(int m) {
        if (m <= MAX) {
            return;
        }
        SideAddress[][][] newAddress = new SideAddress[2][m + 2][m + 2];
        int d = 0;
        while (d <= 1) {
            int r = -1;
            while (r <= m) {
                int c = -1;
                while (c <= m) {
                    newAddress[d][r + 1][c + 1] = r + 1 <= MAX && c + 1 <= MAX ? ADDRESS[d][r + 1][c + 1] : new SideAddress(d, r, c);
                    ++c;
                }
                ++r;
            }
            ++d;
        }
        MAX = m;
        ADDRESS = newAddress;
    }

    public static void createSideAddressInstances(Size size) {
        int m = size.getCols() > size.getCols() ? size.getRows() : size.getCols();
        SideAddress.createSideAddressInstances(m);
    }

    public static SideAddress sideAddress(int d, int r, int c) {
        if (d >= 0 && d <= 1 && r >= -1 && r <= MAX && c >= -1 && c <= MAX) {
            return ADDRESS[d][r + 1][c + 1];
        }
        return new SideAddress(d, r, c);
    }

    public static SideAddress get(Address pos, int dir) {
        switch (dir) {
            case 0: {
                return SideAddress.sideAddress(1, pos.r() - 1, pos.c());
            }
            case 1: {
                return SideAddress.sideAddress(0, pos.r(), pos.c() - 1);
            }
            case 2: {
                return SideAddress.sideAddress(1, pos.r(), pos.c());
            }
            case 3: {
                return SideAddress.sideAddress(0, pos.r(), pos.c());
            }
        }
        return NOWHERE;
    }

    private SideAddress(int d, int r, int c) {
        this.d = d;
        this.r = r;
        this.c = c;
    }

    public int d() {
        return this.d;
    }

    public int r() {
        return this.r;
    }

    public int c() {
        return this.c;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SideAddress)) {
            return false;
        }
        SideAddress address = (SideAddress)o;
        if (address == this) {
            return true;
        }
        return address.r == this.r && address.c == this.c && address.d == this.d;
    }

    public int hashCode() {
        return (this.d * 1000 + this.r) * 1000 + this.c;
    }

    @Override
    public int compareTo(SideAddress o) {
        if (this.d < o.d) {
            return -1;
        }
        if (this.d > o.d) {
            return 1;
        }
        if (this.r < o.r) {
            return -1;
        }
        if (this.r > o.r) {
            return 1;
        }
        if (this.r < o.r) {
            return -1;
        }
        if (this.c < o.c) {
            return -1;
        }
        if (this.c > o.c) {
            return 1;
        }
        return 0;
    }

    public static SideAddress nextBorder(SideAddress border, int direction) {
        int d = border.d();
        int r = border.r();
        int c = border.c();
        int dd = -1;
        int rr = -1;
        int cc = -1;
        if (d == 0) {
            if (direction == 0) {
                dd = 0;
                rr = r;
                cc = c - 1;
            } else if (direction == 1) {
                dd = 0;
                rr = r;
                cc = c + 1;
            } else if (direction == 2) {
                dd = 1;
                rr = r - 1;
                cc = c;
            } else if (direction == 3) {
                dd = 1;
                rr = r - 1;
                cc = c + 1;
            } else if (direction == 4) {
                dd = 1;
                rr = r;
                cc = c;
            } else if (direction == 5) {
                dd = 1;
                rr = r;
                cc = c + 1;
            }
        } else if (d == 1) {
            if (direction == 0) {
                dd = 1;
                rr = r - 1;
                cc = c;
            } else if (direction == 1) {
                dd = 1;
                rr = r + 1;
                cc = c;
            } else if (direction == 2) {
                dd = 0;
                rr = r;
                cc = c - 1;
            } else if (direction == 3) {
                dd = 0;
                rr = r + 1;
                cc = c - 1;
            } else if (direction == 4) {
                dd = 0;
                rr = r;
                cc = c;
            } else if (direction == 5) {
                dd = 0;
                rr = r + 1;
                cc = c;
            }
        }
        return SideAddress.sideAddress(dd, rr, cc);
    }

    public static Address nextCellFromBorder(SideAddress border, int direction) {
        int d = border.d();
        int r = border.r();
        int c = border.c();
        if (d == 0) {
            if (direction == 0) {
                return Address.address(r, c);
            }
            if (direction == 1) {
                return Address.address(r, c + 1);
            }
        } else if (d == 1) {
            if (direction == 0) {
                return Address.address(r, c);
            }
            if (direction == 1) {
                return Address.address(r + 1, c);
            }
        }
        return null;
    }

    public String toString() {
        return "[" + this.d + "," + this.r + "," + this.c + "]";
    }
}

