/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.norinori;

import pencilbox.common.core.BoardBase;
import pencilbox.common.io.XmlWriterBase;
import pencilbox.norinori.Board;

public class XmlWriter
extends XmlWriterBase {
    @Override
    protected void setBoardData(BoardBase theboard) {
        Board board = (Board)theboard;
        this.outAreas(board.getAreaList().size());
        int rows = board.rows();
        int cols = board.cols();
        int r = 0;
        while (r < rows) {
            this.startBrow(r);
            int c = 0;
            while (c < cols) {
                if (board.getArea(r, c) == null) {
                    this.out("u");
                } else {
                    this.outN(board.getAreaList().indexOf(board.getArea(r, c)));
                }
                ++c;
            }
            this.endBrow();
            ++r;
        }
    }

    @Override
    protected void setAnswerData(BoardBase theboard) {
        Board board = (Board)theboard;
        int rows = board.rows();
        int cols = board.cols();
        int r = 0;
        while (r < rows) {
            this.startArow(r);
            int c = 0;
            while (c < cols) {
                int st = board.getState(r, c);
                if (st == -2) {
                    this.out("w");
                } else if (st == -1) {
                    this.out("s");
                } else {
                    this.out("u");
                }
                ++c;
            }
            this.endArow();
            ++r;
        }
    }

    void outAreas(int v) {
        this.startTag(2, "areas");
        this.attribute("N", v);
        this.emptyTag();
    }
}

