/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.norinori;

import java.util.ArrayList;
import pencilbox.common.core.Address;
import pencilbox.common.core.AreaBase;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator;
import pencilbox.norinori.Area;
import pencilbox.norinori.Board;

public class BoardCopier
extends BoardCopierBase {
    @Override
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Board s = (Board)src;
        Board d = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        rotator.rotateArrayInt2(s.getState(), d.getState());
        for (Area srcArea : s.getAreaList()) {
            Area a = new Area();
            rotator.rotateArea(srcArea, a);
            if (!d.isAreaOn(a)) continue;
            d.addArea(a);
        }
    }

    @Override
    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, AreaBase region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        ArrayList<Area> srcAreaList = new ArrayList<Area>();
        block0: for (Address s : region) {
            Address dd;
            Area srcArea = srcBoard.getArea(s);
            if (srcArea == null || srcAreaList.contains(srcArea)) continue;
            srcAreaList.add(srcArea);
            if (!region.containsAll(srcArea)) continue;
            Area dstArea = new Area();
            for (Address ss : srcArea) {
                dd = this.translateAndRotateAddress(ss, from, to, rotation);
                if (!board.isOn(dd)) continue block0;
            }
            for (Address ss : srcArea) {
                dd = this.translateAndRotateAddress(ss, from, to, rotation);
                if (!board.isOn(dd)) continue;
                Area oldArea = board.getArea(dd);
                if (oldArea != null) {
                    board.removeWholeArea(oldArea);
                }
                board.addCellToArea(dd, dstArea);
            }
        }
        for (Address s : region) {
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            board.changeState(d, srcBoard.getState(s));
        }
    }

    @Override
    public void eraseRegion(BoardBase boardBase, AreaBase region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            board.changeState(s, 0);
        }
        for (Address s : region) {
            Area srcArea = board.getArea(s);
            if (srcArea == null || !region.containsAll(srcArea)) continue;
            board.removeWholeArea(srcArea);
        }
    }
}

