/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelBase;
import pencilbox.shikaku.Board;
import pencilbox.shikaku.Square;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private Color smallSizeColor = new Color(0xFFFF99);
    private Square draggingSquare;

    public Panel() {
        this.setGridColor(Color.GRAY);
        this.setAreaBorderColor(new Color(153));
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.paintAreas(g);
        this.drawNumbers(g);
        this.drawGrid(g);
        this.drawAreaBorders(g);
        this.drawBoardBorder(g);
        this.drawEdges(g);
    }

    private void paintAreas(Graphics2D g) {
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            Square square = this.board.getSquare(p);
            if (square != null) {
                g.setColor(this.areaPaintColor);
                if (this.isIndicateErrorMode()) {
                    int number = square.getNumber();
                    if (number == -2) {
                        g.setColor(this.getErrorColor());
                    } else if (number == 0) {
                        g.setColor(this.smallSizeColor);
                    } else if (number == -1) {
                        g.setColor(this.areaPaintColor);
                    } else if (number < square.getSquareSize()) {
                        g.setColor(this.getErrorColor());
                    } else if (number == square.getSquareSize()) {
                        g.setColor(this.areaPaintColor);
                    } else if (number > square.getSquareSize()) {
                        g.setColor(this.smallSizeColor);
                    }
                } else if (this.isSeparateAreaColorMode()) {
                    g.setColor(Colors.getBrightColor(this.board.getSquare(p).getId()));
                }
                this.paintCell(g, p);
            }
            ++n2;
        }
        Square square = this.getDraggingSquare();
        if (square != null) {
            for (Address p : square.cellSet()) {
                g.setColor(this.draggingAreaColor);
                this.paintCell(g, p);
            }
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int number = this.board.getNumber(p);
            if (number > 0 || number == -1) {
                g.setColor(this.getNumberColor());
                super.placeFilledCircle(g, p, (int)((double)this.getCellSize() * 0.85));
            }
            if (number > 0) {
                g.setColor(this.getBackgroundColor());
                super.placeNumber(g, p, number);
            }
            ++n2;
        }
    }

    private void drawAreaBorders(Graphics2D g) {
        Square square2;
        g.setColor(this.getAreaBorderColor());
        for (Square square2 : this.board.getSquareList()) {
            this.placeSquare(g, square2);
        }
        square2 = this.getDraggingSquare();
        if (square2 != null) {
            this.placeSquare(g, square2);
        }
    }

    private void drawEdges(Graphics2D g) {
        g.setColor(this.borderColor);
        SideAddress[] sideAddressArray = this.board.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            int state = this.board.getEdge(p);
            if (state == 1) {
                this.placeSideLine(g, p);
            }
            ++n2;
        }
    }

    void setDraggingSquare(Square draggingSquare) {
        this.draggingSquare = draggingSquare;
    }

    Square getDraggingSquare() {
        return this.draggingSquare;
    }
}

