/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.masyu;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelBase;
import pencilbox.masyu.Board;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private Color grayPearlColor = Color.GRAY;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.drawNumbers(g);
        this.drawGrid(g);
        this.drawLinks(g);
        this.drawBoardBorder(g);
    }

    private void drawNumbers(Graphics2D g) {
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int number = this.board.getNumber(p);
            if (number == 1) {
                this.placeWhitePearl(g, p);
            } else if (number == 2) {
                this.placeBlackPearl(g, p);
            } else if (number == 3) {
                this.placeGrayPearl(g, p);
            }
            ++n2;
        }
    }

    private void drawLinks(Graphics2D g) {
        SideAddress[] sideAddressArray = this.board.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            int state = this.board.getState(p);
            if (state == 1) {
                g.setColor(this.getLineColor());
                if (this.isSeparateLinkColorMode()) {
                    g.setColor(Colors.getColor(this.board.getLink(p).getId()));
                }
                this.placeLink(g, p);
            } else if (state == -1) {
                g.setColor(this.getCrossColor());
                this.placeSideCross(g, p);
            }
            ++n2;
        }
    }

    private void placeBlackPearl(Graphics2D g, Address p) {
        g.setColor(this.getNumberColor());
        if (this.isIndicateErrorMode()) {
            int n = this.board.checkBlackPearl(p);
            if (n == -1) {
                g.setColor(this.getErrorColor());
            } else if (n == 0) {
                g.setColor(this.getErrorColor());
            }
        }
        this.placeFilledCircle(g, p);
    }

    private void placeWhitePearl(Graphics2D g, Address p) {
        g.setColor(this.getNumberColor());
        if (this.isIndicateErrorMode()) {
            int n = this.board.checkWhitePearl(p);
            if (n == -1) {
                g.setColor(this.getErrorColor());
            } else if (n == 0) {
                g.setColor(this.getErrorColor());
            }
        }
        this.placeBoldCircle(g, p);
    }

    private void placeGrayPearl(Graphics2D g, Address p) {
        g.setColor(this.grayPearlColor);
        this.placeFilledCircle(g, p);
    }
}

