/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hakyukoka;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.hakyukoka.Area;
import pencilbox.hakyukoka.Board;
import pencilbox.hakyukoka.Panel;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int dragState = 0;
    private static final int INIT = 0;
    private static final int PRESS_NEW = 1;
    private static final int PRESS_EXISTING = 2;
    private static final int DRAG_ADD = 3;
    private static final int DRAG_REMOVE = 4;

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(9);
    }

    @Override
    protected int getMaxInputNumber() {
        Address pos = this.getCellCursor().getPosition();
        Area area = this.board.getArea(pos);
        if (area != null) {
            int n = area.size();
            if (n > 9) {
                return n;
            }
            return 9;
        }
        return 9;
    }

    private void setSelectedNumber(int n) {
        ((Panel)this.getPanel()).setSelectedNumber(n);
    }

    Area getDraggingArea() {
        return ((Panel)this.getPanel()).getDraggingArea();
    }

    void setDraggingArea(Area draggingArea) {
        ((Panel)this.getPanel()).setDraggingArea(draggingArea);
    }

    @Override
    protected void leftPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Area area = this.board.getArea(pos);
            if (area == null) {
                area = new Area();
                this.board.addCellToArea(pos, area);
                this.dragState = 1;
            } else {
                this.dragState = 2;
            }
            this.setDraggingArea(area);
        } else {
            if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos))) {
                int n = this.board.getState(pos);
                if (n >= this.getMaxInputNumber()) {
                    this.board.changeAnswerNumber(pos, 0);
                } else if (n >= 0) {
                    this.board.changeAnswerNumber(pos, n + 1);
                }
            }
            this.setSelectedNumber(this.board.getNumberOrState(pos));
        }
    }

    @Override
    protected void leftDragged(Address oldPos, Address pos) {
        if (this.isProblemEditMode()) {
            Area draggingArea = this.getDraggingArea();
            if (draggingArea == null) {
                return;
            }
            Area oldArea = this.board.getArea(pos);
            if (this.dragState == 1 || this.dragState == 2) {
                this.dragState = oldArea == null || oldArea != draggingArea ? 3 : 4;
            }
            if (this.dragState == 3) {
                if (oldArea != null && oldArea != draggingArea) {
                    this.board.removeCellFromArea(pos, oldArea);
                    this.board.addCellToArea(pos, draggingArea);
                } else if ((oldArea == null || oldArea != draggingArea) && oldArea == null) {
                    this.board.addCellToArea(pos, draggingArea);
                }
            } else if (this.dragState == 4) {
                if (!this.isOn(oldPos)) {
                    return;
                }
                Area oldoldArea = this.board.getArea(oldPos);
                if (oldoldArea != null) {
                    this.board.removeCellFromArea(oldPos, oldoldArea);
                }
            }
        }
    }

    @Override
    protected void leftReleased(Address pos) {
        if (this.isProblemEditMode()) {
            if (this.dragState == 2) {
                this.board.removeCellFromArea(pos, this.board.getArea(pos));
            }
            this.setDraggingArea(null);
            this.dragState = 0;
        }
    }

    @Override
    protected void rightPressed(Address pos) {
        if (!this.isProblemEditMode()) {
            int n;
            if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos) || (n = this.board.getState(pos)) <= 0)) {
                this.board.changeAnswerNumber(pos, n - 1);
            }
            this.setSelectedNumber(this.board.getNumberOrState(pos));
        }
    }

    @Override
    protected void rightDragged(Address pos) {
        if (this.isProblemEditMode()) {
            this.rightPressed(pos);
        }
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeFixedNumber(pos, num);
            if (this.isSymmetricPlacementMode() && !this.board.isStable(posS = this.getSymmetricPosition(pos))) {
                this.board.changeFixedNumber(posS, -2);
            }
        } else if (this.isCursorOn() && num >= 0 && !this.board.isStable(pos)) {
            this.board.changeAnswerNumber(pos, num);
        }
    }

    @Override
    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeFixedNumber(pos, 0);
            if (this.isSymmetricPlacementMode() && this.board.isStable(posS = this.getSymmetricPosition(pos))) {
                this.board.changeFixedNumber(posS, 0);
            }
        } else if (this.isCursorOn() && !this.board.isStable(pos)) {
            this.board.changeAnswerNumber(pos, 0);
        }
    }

    @Override
    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeFixedNumber(pos, -2);
            if (this.isSymmetricPlacementMode() && !this.board.isStable(posS = this.getSymmetricPosition(pos))) {
                this.board.changeFixedNumber(posS, -2);
            }
        }
    }
}

